/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory;

import cz.mcsworld.eroded.config.territory.TerritoryConfig;
import cz.mcsworld.eroded.world.territory.TerritoryCell;

public final class TerritoryThreatResolver {
    private TerritoryThreatResolver() {
    }

    public static float computeThreat(TerritoryCell cell, long tick) {
        TerritoryConfig.Server cfg = TerritoryConfig.get().server;
        int mining = cell.getMining(tick);
        int pollution = cell.getPollution(tick);
        int forest = cell.getForestation(tick);
        float miningN = TerritoryThreatResolver.clamp((float)mining / 100.0f, 0.0f, 1.0f);
        float pollutionN = TerritoryThreatResolver.clamp((float)pollution / 100.0f, 0.0f, 1.0f);
        float forestN = TerritoryThreatResolver.clamp((float)forest / 100.0f, 0.0f, 1.0f);
        float threat = miningN * cfg.miningWeight + pollutionN * cfg.pollutionWeight - forestN * cfg.forestWeight;
        float scoreN = TerritoryThreatResolver.clamp((float)cell.getMiningScore() / 300.0f, 0.0f, 1.0f);
        return TerritoryThreatResolver.clamp(threat += scoreN * 0.25f, 0.0f, 1.0f);
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }
}

