/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory;

public final class TerritoryCell {
    private long lastMiningActivityTick;
    private int miningScore;
    private int mining;
    private int pollution;
    private int forestation;
    private long lastTick;

    public void setMiningScore(int value) {
        this.miningScore = value;
    }

    public void setMining(int value) {
        this.mining = value;
    }

    public void setPollution(int value) {
        this.pollution = value;
    }

    public void setForestation(int value) {
        this.forestation = value;
    }

    public void setLastTick(long value) {
        this.lastTick = value;
    }

    public int getMiningRaw() {
        return this.mining;
    }

    public int getPollutionRaw() {
        return this.pollution;
    }

    public int getForestationRaw() {
        return this.forestation;
    }

    public long getLastTick() {
        return this.lastTick;
    }

    public void incrementMiningScore() {
        ++this.miningScore;
    }

    public int getMiningScore() {
        return this.miningScore;
    }

    public int getMining(long tick) {
        this.applyDecay(tick);
        return this.mining;
    }

    public int getPollution(long tick) {
        this.applyDecay(tick);
        return this.pollution;
    }

    public int getForestation(long tick) {
        this.applyDecay(tick);
        return this.forestation;
    }

    public void addMining(int value, long tick) {
        this.applyDecay(tick);
        this.mining = Math.max(0, this.mining + value);
        this.lastTick = tick;
    }

    public void addPollution(int value, long tick) {
        this.applyDecay(tick);
        this.pollution = Math.max(0, this.pollution + value);
        this.lastTick = tick;
    }

    public void addForestation(int value, long tick) {
        this.applyDecay(tick);
        this.forestation = Math.max(0, this.forestation + value);
        this.lastTick = tick;
    }

    public void setLastMiningActivityTick(long tick) {
        this.lastMiningActivityTick = tick;
    }

    public long getLastMiningActivityTick() {
        return this.lastMiningActivityTick;
    }

    private void applyDecay(long tick) {
        if (this.lastTick == 0L) {
            this.lastTick = tick;
            return;
        }
        long elapsed = tick - this.lastTick;
        if (elapsed < 1200L) {
            return;
        }
        int steps = (int)(elapsed / 1200L);
        this.mining = Math.max(0, this.mining - steps);
        this.pollution = Math.max(0, this.pollution - steps);
        this.forestation = Math.max(0, this.forestation - steps);
        this.lastTick += (long)steps * 1200L;
    }
}

