/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.skills;

import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.skills.SkillType;
import java.util.EnumMap;
import java.util.Map;

public class SkillData {
    private final Map<SkillType, Float> cgMap = new EnumMap<SkillType, Float>(SkillType.class);
    private int energy;
    private long lastRegenTime = System.currentTimeMillis();
    private boolean collapsed = false;
    private long collapseUntilMs = 0L;
    private EnergyState lastEnergyState = EnergyState.NORMAL;
    private int lastFlashes = -1;

    public SkillData() {
        for (SkillType type : SkillType.values()) {
            this.cgMap.put(type, Float.valueOf(0.0f));
        }
    }

    public float getCg(SkillType type) {
        return this.cgMap.getOrDefault((Object)type, Float.valueOf(0.0f)).floatValue();
    }

    public void addCg(SkillType type, float baseAmount) {
        float current = this.getCg(type);
        if (current >= 100.0f) {
            return;
        }
        float multiplier = 1.0f - current / 120.0f;
        float gained = baseAmount * Math.max(multiplier, 0.05f);
        this.cgMap.put(type, Float.valueOf(Math.min(current + gained, 100.0f)));
    }

    public void setCg(SkillType type, float value) {
        this.cgMap.put(type, Float.valueOf(Math.max(0.0f, Math.min(100.0f, value))));
    }

    public static int severity(EnergyState state) {
        return switch (state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
        };
    }

    private EnergyState calculateEnergyState() {
        EnergyConfig root = EnergyConfig.get();
        EnergyConfig.Server.Thresholds cfg = root.server.thresholds;
        if (this.collapsed) {
            return EnergyState.EMPTY;
        }
        int max = this.getMaxEnergy();
        if (max <= 0) {
            return EnergyState.NORMAL;
        }
        float percent = (float)this.energy / (float)max * 100.0f;
        if (percent <= cfg.emptyPercent) {
            return EnergyState.EMPTY;
        }
        if (percent <= cfg.exhaustedPercent) {
            return EnergyState.EXHAUSTED;
        }
        if (percent <= cfg.tiredPercent) {
            return EnergyState.TIRED;
        }
        return EnergyState.NORMAL;
    }

    public EnergyState detectWorseningState() {
        EnergyState current = this.calculateEnergyState();
        if (SkillData.severity(current) > SkillData.severity(this.lastEnergyState)) {
            this.lastEnergyState = current;
            return current;
        }
        if (SkillData.severity(current) < SkillData.severity(this.lastEnergyState)) {
            this.lastEnergyState = current;
        }
        return null;
    }

    public EnergyState getEnergyState() {
        return this.calculateEnergyState();
    }

    public int getEnergy() {
        this.regenerateEnergy();
        return this.energy;
    }

    public int getMaxEnergy() {
        return this.getConfig().server.core.maxEnergy;
    }

    public boolean hasEnoughEnergy(int amount) {
        this.regenerateEnergy();
        return !this.collapsed && this.energy >= amount;
    }

    public boolean canAffordEnergy(int amount) {
        this.regenerateEnergy();
        return !this.collapsed && this.energy >= amount;
    }

    public boolean tryConsumeEnergy(int amount) {
        if (!this.hasEnoughEnergy(amount)) {
            return false;
        }
        this.consumeEnergy(amount);
        return true;
    }

    public void consumeEnergy(int amount) {
        if (this.collapsed || amount <= 0) {
            return;
        }
        this.regenerateEnergy();
        this.energy = Math.max(0, this.energy - amount);
        if (this.energy == 0) {
            this.enterCollapse();
            return;
        }
    }

    public void addEnergy(int amount) {
        this.regenerateEnergy();
        if (amount <= 0) {
            return;
        }
        this.energy = Math.min(this.getMaxEnergy(), this.energy + amount);
        if (this.energy > 0) {
            this.collapsed = false;
        }
        this.lastEnergyState = this.calculateEnergyState();
    }

    public void setEnergy(int value) {
        this.energy = Math.max(0, Math.min(this.getMaxEnergy(), value));
        this.collapsed = false;
        this.lastEnergyState = this.calculateEnergyState();
    }

    public void setEnergyAfterDeath(float ratio) {
        int target = Math.max(0, (int)((float)this.getMaxEnergy() * ratio));
        this.setEnergy(target);
    }

    public void initialize() {
        this.energy = this.getMaxEnergy();
        this.collapsed = false;
        this.lastRegenTime = System.currentTimeMillis();
        this.lastEnergyState = this.calculateEnergyState();
    }

    private void enterCollapse() {
        EnergyConfig energyRoot = EnergyConfig.get();
        EnergyConfig.Server.Collapse cfg = energyRoot.server.collapse;
        this.collapsed = true;
        this.collapseUntilMs = System.currentTimeMillis() + (long)cfg.collapseDelayMs;
    }

    private void regenerateEnergy() {
        EnergyConfig root = EnergyConfig.get();
        EnergyConfig.Server.Regen cfg = root.server.regen;
        long now = System.currentTimeMillis();
        if (this.collapsed) {
            if (now < this.collapseUntilMs) {
                return;
            }
            this.energy = 1;
            this.collapsed = false;
            this.lastRegenTime = now;
            return;
        }
        if (!cfg.passiveRegenEnabled) {
            return;
        }
        long elapsed = now - this.lastRegenTime;
        long intervalMs = (long)cfg.regenIntervalSeconds * 1000L;
        if (elapsed < intervalMs) {
            return;
        }
        int restoredSegments = (int)(elapsed / intervalMs);
        int restoreAmount = restoredSegments * root.server.core.energyPerSegment;
        if (restoreAmount > 0) {
            this.energy = Math.min(this.getMaxEnergy(), this.energy + restoreAmount);
            this.lastRegenTime += (long)restoredSegments * intervalMs;
        }
    }

    private EnergyConfig getConfig() {
        return EnergyConfig.get();
    }

    public static enum EnergyState {
        NORMAL,
        TIRED,
        EXHAUSTED,
        EMPTY;

    }
}

