/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.energy;

import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.network.EnergySyncPacket;
import cz.mcsworld.eroded.network.EnergyWarningPacket;
import cz.mcsworld.eroded.network.SafeNetworkUtil;
import cz.mcsworld.eroded.skills.SkillData;
import cz.mcsworld.eroded.skills.SkillManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class EnergySyncHandler {
    private static final Map<UUID, Integer> LAST_SENT = new ConcurrentHashMap<UUID, Integer>();

    private EnergySyncHandler() {
    }

    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> EnergySyncHandler.forceSync(handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> LAST_SENT.remove(handler.method_32311().method_5667()));
        ServerTickEvents.END_SERVER_TICK.register(EnergySyncHandler::tick);
    }

    private static void tick(MinecraftServer server) {
        EnergyConfig root = EnergyConfig.get();
        EnergyConfig.Server.Warnings cfg = root.server.warnings;
        for (class_3222 player : server.method_3760().method_14571()) {
            SkillData data;
            SkillData.EnergyState worse;
            boolean changed = EnergySyncHandler.syncIfChanged(player);
            if (!cfg.warningsEnabled || !changed || (worse = (data = SkillManager.get(player)).detectWorseningState()) == null) continue;
            SafeNetworkUtil.safeSend(player, new EnergyWarningPacket(worse));
        }
    }

    public static boolean syncIfChanged(class_3222 player) {
        int last;
        SkillData data = SkillManager.get(player);
        int energy = data.getEnergy();
        if (energy == (last = LAST_SENT.getOrDefault(player.method_5667(), Integer.MIN_VALUE).intValue())) {
            return false;
        }
        LAST_SENT.put(player.method_5667(), energy);
        SafeNetworkUtil.safeSend(player, new EnergySyncPacket(energy));
        return true;
    }

    public static void forceSync(class_3222 player) {
        SkillData data = SkillManager.get(player);
        int energy = data.getEnergy();
        LAST_SENT.put(player.method_5667(), energy);
        SafeNetworkUtil.safeSend(player, new EnergySyncPacket(energy));
    }
}

