/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.death;

import com.mojang.authlib.GameProfile;
import cz.mcsworld.eroded.config.death.DeathConfig;
import cz.mcsworld.eroded.death.DeathChestState;
import cz.mcsworld.eroded.death.block.ErodedBlocks;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_8113;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public final class DeathHologramHandler {
    private static final String TAG = "eroded_death_hologram";
    private static final String TAG_HEAD = "rotating_head";
    private static final String TAG_EXPIRY = "expiry_";
    private static final String TAG_NAME = "name_";
    private static final String TAG_BASE_Y = "baseY_";
    private static final String TAG_HOLOGRAM_ID = "hid_";

    private DeathHologramHandler() {
    }

    public static void register() {
        ServerTickEvents.END_WORLD_TICK.register(DeathHologramHandler::tick);
    }

    public static void spawn(class_3218 world, class_2338 pos, GameProfile profile, int protectionSeconds, UUID hologramId) {
        long expiryEpochMs = System.currentTimeMillis() + (long)protectionSeconds * 1000L;
        String name = profile.getName();
        String hidTag = TAG_HOLOGRAM_ID + String.valueOf(hologramId);
        double baseX = (double)pos.method_10263() + 0.5;
        double baseY = pos.method_10264();
        double baseZ = (double)pos.method_10260() + 0.5;
        double standBaseY = baseY + 0.3;
        class_1531 stand = new class_1531((class_1937)world, baseX, standBaseY, baseZ);
        stand.method_5648(true);
        stand.method_5875(true);
        stand.method_5803(true);
        stand.method_5684(true);
        class_1799 head = new class_1799((class_1935)class_1802.field_8575);
        head.method_57379(class_9334.field_49617, (Object)new class_9296(profile));
        stand.method_5673(class_1304.field_6169, head);
        stand.method_5780(TAG);
        stand.method_5780(TAG_HEAD);
        stand.method_5780(hidTag);
        stand.method_5780(TAG_EXPIRY + expiryEpochMs);
        stand.method_5780(TAG_BASE_Y + standBaseY);
        world.method_8649((class_1297)stand);
        double textY = baseY + 2.6;
        class_8113.class_8123 text = new class_8113.class_8123(class_1299.field_42457, (class_1937)world);
        text.method_5814(baseX, textY, baseZ);
        text.method_48847(class_8113.class_8114.field_42409);
        text.method_48910(0x60000000);
        text.method_48911(DeathHologramHandler.buildText(name, protectionSeconds));
        text.method_5780(TAG);
        text.method_5780(hidTag);
        text.method_5780(TAG_EXPIRY + expiryEpochMs);
        text.method_5780(TAG_NAME + name);
        world.method_8649((class_1297)text);
    }

    public static void tick(class_3218 world) {
        UUID hid;
        boolean eachSecond = world.method_8503().method_3780() % 20 == 0;
        DeathConfig.Hologram cfg = DeathConfig.get().hologram;
        DeathChestState state = DeathChestState.get(world);
        if (eachSecond) {
            Set activeHids = state.all().stream().map(DeathChestState.Entry::hologramId).collect(Collectors.toSet());
            for (class_1297 e : world.method_27909()) {
                if (!e.method_5752().contains(TAG) || (hid = DeathHologramHandler.getHologramIdFromTags(e)) == null || activeHids.contains(hid)) continue;
                e.method_31472();
            }
        }
        for (DeathChestState.Entry entry : state.all()) {
            class_2338 pos = entry.pos();
            hid = entry.hologramId();
            String hidTag = TAG_HOLOGRAM_ID + String.valueOf(hid);
            if (!world.method_8320(pos).method_27852(ErodedBlocks.DEATH_ENDER_CHEST)) {
                DeathHologramHandler.removeById(world, hid);
                continue;
            }
            if (!world.method_22340(pos)) continue;
            class_238 box = new class_238(pos).method_1009(1.0, 4.0, 1.0);
            for (class_1297 e : world.method_8335(null, box)) {
                if (!e.method_5752().contains(hidTag)) continue;
                if (e instanceof class_1531) {
                    class_1531 stand = (class_1531)e;
                    if (e.method_5752().contains(TAG_HEAD)) {
                        float yaw = (float)world.method_8503().method_3780() * cfg.rotationSpeed % 360.0f;
                        stand.method_36456(yaw);
                        double baseY = DeathHologramHandler.getBaseY((class_1297)stand);
                        double bob = Math.sin((float)world.method_8503().method_3780() * cfg.bobbingSpeed) * (double)cfg.bobbingAmplitude;
                        stand.method_5814(stand.method_23317(), baseY + bob, stand.method_23321());
                    }
                }
                if (!eachSecond || !(e instanceof class_8113.class_8123)) continue;
                class_8113.class_8123 text = (class_8113.class_8123)e;
                long expiry = DeathHologramHandler.getExpiry(e);
                if (expiry <= 0L || System.currentTimeMillis() >= expiry) continue;
                int remainingSeconds = (int)((expiry - System.currentTimeMillis()) / 1000L);
                text.method_48911(DeathHologramHandler.buildText(DeathHologramHandler.getName(e), remainingSeconds));
            }
        }
    }

    public static void removeById(class_3218 world, UUID hologramId) {
        String hidTag = TAG_HOLOGRAM_ID + String.valueOf(hologramId);
        for (class_1297 e : world.method_27909()) {
            if (!e.method_5752().contains(hidTag)) continue;
            e.method_31472();
        }
    }

    public static class_2561 buildText(String name, int seconds) {
        int safeSeconds = Math.max(0, seconds);
        int min = safeSeconds / 60;
        int sec = safeSeconds % 60;
        class_124 timeColor = safeSeconds >= 60 ? class_124.field_1060 : (safeSeconds >= 30 ? class_124.field_1054 : class_124.field_1061);
        return class_2561.method_43470((String)"\n ").method_10852((class_2561)class_2561.method_43470((String)name).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43471((String)"eroded.death.hologram.line.protection")).method_10852((class_2561)class_2561.method_43470((String)String.format(" %d:%02d", min, sec)).method_27695(new class_124[]{timeColor, class_124.field_1067})).method_10852((class_2561)class_2561.method_43471((String)"eroded.death.hologram.line.hint")).method_10852((class_2561)class_2561.method_43470((String)"\n "));
    }

    private static UUID getHologramIdFromTags(class_1297 e) {
        for (String tag : e.method_5752()) {
            if (!tag.startsWith(TAG_HOLOGRAM_ID)) continue;
            try {
                return UUID.fromString(tag.substring(TAG_HOLOGRAM_ID.length()));
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static double getBaseY(class_1297 e) {
        for (String tag : e.method_5752()) {
            if (!tag.startsWith(TAG_BASE_Y)) continue;
            try {
                return Double.parseDouble(tag.substring(TAG_BASE_Y.length()));
            }
            catch (Exception exception) {
            }
        }
        return e.method_23318();
    }

    private static long getExpiry(class_1297 e) {
        for (String tag : e.method_5752()) {
            if (!tag.startsWith(TAG_EXPIRY)) continue;
            try {
                return Long.parseLong(tag.substring(TAG_EXPIRY.length()));
            }
            catch (Exception exception) {
            }
        }
        return -1L;
    }

    private static String getName(class_1297 e) {
        for (String tag : e.method_5752()) {
            if (!tag.startsWith(TAG_NAME)) continue;
            return tag.substring(TAG_NAME.length());
        }
        return "Unknown";
    }
}

