/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.combat;

import cz.mcsworld.eroded.config.combat.CombatConfig;
import cz.mcsworld.eroded.network.DodgeRequestPacket;
import cz.mcsworld.eroded.skills.SkillData;
import cz.mcsworld.eroded.skills.SkillManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class DodgeHandler {
    private static final Map<UUID, Integer> COOLDOWNS = new HashMap<UUID, Integer>();

    private DodgeHandler() {
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(DodgeRequestPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> DodgeHandler.handle(player, payload));
        });
    }

    private static void handle(class_3222 player, DodgeRequestPacket pkt) {
        int last;
        CombatConfig root = CombatConfig.get();
        if (!root.enabled || !root.dodge.enabled) {
            return;
        }
        CombatConfig.Dodge cfg = root.dodge;
        if (!cfg.allowBackward && pkt.dirZ() < 0.0f) {
            return;
        }
        if (!cfg.allowSideways && pkt.dirX() != 0.0f) {
            return;
        }
        UUID id = player.method_5667();
        int ticks = player.method_5682().method_3780();
        if (ticks - (last = COOLDOWNS.getOrDefault(id, -9999).intValue()) < cfg.cooldownTicks) {
            return;
        }
        SkillData data = SkillManager.get(player);
        if (!data.tryConsumeEnergy(cfg.energyCost)) {
            return;
        }
        class_243 dir = DodgeHandler.resolveDirection(player, pkt);
        class_243 start = player.method_19538();
        class_243 safeTarget = DodgeHandler.findSafeTarget(player, start, dir, cfg.maxDistance, cfg.stepSize);
        if (safeTarget == null) {
            return;
        }
        player.method_5859(safeTarget.field_1352, player.method_23318(), safeTarget.field_1350);
        COOLDOWNS.put(id, ticks);
    }

    private static class_243 resolveDirection(class_3222 player, DodgeRequestPacket pkt) {
        float yaw = player.method_36454();
        float rad = yaw * ((float)Math.PI / 180);
        class_243 forward = new class_243((double)(-class_3532.method_15374((float)rad)), 0.0, (double)class_3532.method_15362((float)rad));
        class_243 right = new class_243((double)class_3532.method_15362((float)rad), 0.0, (double)class_3532.method_15374((float)rad));
        if (pkt.dirZ() > 0.0f) {
            return forward;
        }
        if (pkt.dirZ() < 0.0f) {
            return forward.method_22882();
        }
        if (pkt.dirX() > 0.0f) {
            return right;
        }
        return right.method_22882();
    }

    private static class_243 findSafeTarget(class_3222 player, class_243 start, class_243 dir, double maxDistance, double step) {
        class_238 box = player.method_5829();
        class_243 lastSafe = start;
        for (double d = step; d <= maxDistance; d += step) {
            class_243 pos = start.method_1019(dir.method_1021(d));
            class_238 moved = box.method_989(pos.field_1352 - start.field_1352, 0.0, pos.field_1350 - start.field_1350);
            if (!player.method_51469().method_8587((class_1297)player, moved)) break;
            lastSafe = pos;
        }
        return lastSafe.equals((Object)start) ? null : lastSafe;
    }
}

