/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.region;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.entry.region.RegionEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.widget.DisplayedEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import net.minecraft.class_332;
import org.joml.Vector3f;

public class RegionEntryWidget<T extends RegionEntry<T>>
extends DisplayedEntryWidget {
    private final RealRegionEntry<T> entry;

    RegionEntryWidget(RealRegionEntry<T> entry, int x, int y, int entrySize) {
        super(new Point(x, y), entrySize);
        this.entry = entry;
        this.clearEntries().entry(entry.getEntry().toStack());
    }

    @Override
    protected FavoriteEntry asFavoriteEntry() {
        return this.entry.region.listener.asFavorite(this.entry);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return super.containsMouse(mouseX, mouseY) && this.entry.region.containsMouse(mouseX, mouseY);
    }

    @Override
    protected boolean reverseFavoritesAction() {
        return true;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        Optional<ScreenOverlay> overlayOptional = REIRuntime.getInstance().getOverlay();
        Optional<Supplier<Collection<FavoriteMenuEntry>>> menuEntries = this.entry.getEntry().getMenuEntries();
        FloatingPoint value = (FloatingPoint)this.entry.pos.value();
        FloatingPoint target = (FloatingPoint)this.entry.pos.target();
        if (Math.abs(value.x - target.x) < 1.0 && Math.abs(value.y - target.y) < 1.0 && overlayOptional.isPresent() && menuEntries.isPresent()) {
            ScreenOverlayImpl overlay = (ScreenOverlayImpl)overlayOptional.get();
            MenuAccess access = overlay.menuAccess();
            UUID uuid = this.entry.getEntry().getUuid();
            access.openOrClose(uuid, this.getBounds(), menuEntries.get());
        }
        Vector3f vector3f = new Vector3f((float)mouseX, (float)mouseY, 1.0f);
        graphics.method_51448().transform(vector3f);
        super.method_25394(graphics, (int)vector3f.x(), (int)vector3f.y(), delta);
    }

    @Override
    protected boolean doAction(double mouseX, double mouseY, int button) {
        return this.entry.getEntry().doAction(button) || super.doAction(mouseX, mouseY, button);
    }

    public RealRegionEntry<T> getEntry() {
        return this.entry;
    }
}

