/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.component;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.component.ITravelersBackpack;
import com.tiviacz.travelersbackpack.component.TravelersBackpackComponent;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentFactoryRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentInitializer;
import org.ladysnake.cca.api.v3.entity.RespawnCopyStrategy;

public class ComponentUtils
implements EntityComponentInitializer {
    public static final ComponentKey<ITravelersBackpack> WEARABLE = ComponentRegistry.getOrCreate((class_2960)class_2960.method_60655((String)"travelersbackpack", (String)"travelersbackpack"), ITravelersBackpack.class);
    public static final int[] LOAD_ALL = new int[]{1, 1, 1};
    public static final int[] NO_ITEMS = new int[]{0, 0, 0};
    public static final int[] UPGRADES_ONLY = new int[]{0, 1, 0};
    public static final int[] TOOLS_ONLY = new int[]{0, 0, 1};

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(WEARABLE, TravelersBackpackComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
    }

    public static Optional<ITravelersBackpack> getComponent(class_1657 player) {
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of((ITravelersBackpack)player.getComponent(WEARABLE));
    }

    public static void synchronise(class_1657 player) {
        if (player instanceof class_3222) {
            ComponentUtils.getComponent(player).ifPresent(ITravelersBackpack::synchronise);
        }
    }

    public static boolean isWearingBackpack(class_1657 player) {
        if (TravelersBackpack.enableIntegration()) {
            if (TravelersBackpack.enableTrinkets()) {
                if (TrinketsApi.getTrinketComponent((class_1309)player).isPresent()) {
                    return ((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).isEquipped(t -> t.method_7909() instanceof TravelersBackpackItem);
                }
            } else if (AccessoriesCapability.get((class_1309)player) != null) {
                return AccessoriesCapability.get((class_1309)player).isEquipped(t -> t.method_7909() instanceof TravelersBackpackItem);
            }
            return false;
        }
        if (ComponentUtils.getComponent(player).isPresent()) {
            return ComponentUtils.getComponent(player).get().hasBackpack() && ComponentUtils.getComponent(player).get().getBackpack().method_7909() instanceof TravelersBackpackItem;
        }
        return false;
    }

    public static class_1799 getWearingBackpack(class_1657 player) {
        if (TravelersBackpack.enableIntegration()) {
            if (TravelersBackpack.enableTrinkets()) {
                return ComponentUtils.isWearingBackpack(player) ? (class_1799)((class_3545)((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).getEquipped(t -> t.method_7909() instanceof TravelersBackpackItem).getFirst()).method_15441() : class_1799.field_8037;
            }
            if (ComponentUtils.isWearingBackpack(player) && AccessoriesCapability.get((class_1309)player).getFirstEquipped(t -> t.method_7909() instanceof TravelersBackpackItem) != null) {
                return AccessoriesCapability.get((class_1309)player).getFirstEquipped(t -> t.method_7909() instanceof TravelersBackpackItem).stack();
            }
            return class_1799.field_8037;
        }
        return ComponentUtils.isWearingBackpack(player) ? ComponentUtils.getComponent(player).get().getBackpack() : class_1799.field_8037;
    }

    public static void equipBackpack(class_1657 player, class_1799 stack) {
        if (ComponentUtils.getComponent(player).isPresent() && !ComponentUtils.isWearingBackpack(player)) {
            ComponentUtils.getComponent(player).ifPresent(attachment -> attachment.equipBackpack(stack));
            player.method_37908().method_8396(null, player.method_24515(), (class_3414)class_3417.field_14581.comp_349(), class_3419.field_15248, 1.0f, (1.0f + (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
            ComponentUtils.synchronise(player);
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, class_1799 stack) {
        return ComponentUtils.getBackpackWrapper(player, stack, LOAD_ALL);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, class_1799 stack, int[] dataLoad) {
        if (TravelersBackpack.enableIntegration()) {
            if (ComponentUtils.isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, stack, dataLoad);
            }
            return null;
        }
        if (ComponentUtils.isWearingBackpack(player)) {
            return ComponentUtils.getComponent(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapperArtificial(class_1657 player) {
        return ComponentUtils.getBackpackWrapper(player, NO_ITEMS);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player) {
        return ComponentUtils.getBackpackWrapper(player, LOAD_ALL);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, int[] dataLoad) {
        if (TravelersBackpack.enableIntegration()) {
            if (ComponentUtils.isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, ComponentUtils.getWearingBackpack(player), dataLoad);
            }
            return null;
        }
        if (ComponentUtils.isWearingBackpack(player)) {
            return ComponentUtils.getComponent(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }
}

