/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Locale;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.Estimator;

public abstract class Abstract2DLinearEstimator<C, TBatch extends Estimator.DataBatch<DataPair<C>>, TModel extends LinearFunction<C, TBatch>>
extends Estimator<C, DataPair<C>, TBatch, Long, Long, TModel> {
    protected final long initialOutput;

    public Abstract2DLinearEstimator(long initialOutput) {
        this.initialOutput = initialOutput;
    }

    protected static abstract class LinearFunction<C, TBatch extends Estimator.DataBatch<DataPair<C>>>
    implements Estimator.Model<Long, Long, TBatch> {
        protected final long initialOutput;
        protected double yIntercept;
        protected double slope;
        protected int gatheredSamples = 0;

        public LinearFunction(long initialOutput) {
            this.initialOutput = initialOutput;
        }

        @Override
        public Long predict(Long input) {
            if (this.gatheredSamples == 0) {
                return this.initialOutput;
            }
            return (long)(this.yIntercept + this.slope * (double)input.longValue());
        }

        public String toString() {
            return String.format(Locale.US, "s=%.2f,y=%.0f", this.slope, this.yIntercept);
        }
    }

    protected static abstract class LinearRegressionBatch<C>
    extends ObjectArrayList<DataPair<C>>
    implements Estimator.DataBatch<DataPair<C>> {
        protected LinearRegressionBatch() {
        }

        @Override
        public void addDataPoint(DataPair<C> input) {
            this.add(input);
        }
    }

    public static interface DataPair<C>
    extends Estimator.DataPoint<C> {
        public long x();

        public long y();
    }
}

