/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.client.model.BackpackDynamicModel;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.List;
import java.util.Set;
import net.minecraft.class_10401;
import net.minecraft.class_10402;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10508;
import net.minecraft.class_10515;
import net.minecraft.class_10526;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BackpackItemModel
implements class_10439 {
    private static final class_809 ITEM_TRANSFORMS = BackpackItemModel.createItemTransforms();
    private final BackpackDynamicModel.DynamicBlockStateModel baseModel;
    private final List<class_10401> tintSources;
    private final Supplier<Vector3f[]> extents;

    private static class_809 createItemTransforms() {
        return new class_809(new class_804((Vector3fc)new Vector3f(60.0f, -180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.09375f, 0.03125f), (Vector3fc)new Vector3f(0.7f, 0.7f, 0.7f)), new class_804((Vector3fc)new Vector3f(60.0f, -180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.09375f, 0.03125f), (Vector3fc)new Vector3f(0.7f, 0.7f, 0.7f)), new class_804((Vector3fc)new Vector3f(0.0f, -90.0f, 12.5f), (Vector3fc)new Vector3f(0.070625f, 0.375f, 0.125f), (Vector3fc)new Vector3f(0.68f, 0.68f, 0.68f)), new class_804((Vector3fc)new Vector3f(0.0f, -90.0f, 12.5f), (Vector3fc)new Vector3f(0.070625f, 0.375f, 0.125f), (Vector3fc)new Vector3f(0.68f, 0.68f, 0.68f)), new class_804((Vector3fc)new Vector3f(0.0f, 180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.90625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)), new class_804((Vector3fc)new Vector3f(30.0f, -38.0f, 0.0f), (Vector3fc)new Vector3f(-0.015625f, 0.140625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)), new class_804((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.125f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f)), new class_804((Vector3fc)new Vector3f(0.0f, 180.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.140625f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)));
    }

    public BackpackItemModel(BackpackDynamicModel.DynamicBlockStateModel baseModel, List<class_10401> tintSources) {
        this.baseModel = baseModel;
        this.tintSources = tintSources;
        this.extents = Suppliers.memoize(() -> class_10430.method_67990(baseModel.getQuads()));
    }

    public void method_65584(class_10444 stackRenderState, class_1799 stack, class_10442 itemModelResolver, class_811 displayContext, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity, int seed) {
        stackRenderState.method_70946((Object)this);
        class_10444.class_10446 renderLayer = stackRenderState.method_65601();
        if (stack.method_7958()) {
            renderLayer.method_65615(class_10444.class_10445.field_55342);
            stackRenderState.method_70946((Object)class_10444.class_10445.field_55342);
        }
        int k = this.tintSources.size();
        int[] aint = renderLayer.method_65613(k);
        for (int i = 0; i < k; ++i) {
            int j;
            aint[i] = j = this.tintSources.get(i).method_65389(stack, clientLevel, livingEntity);
            stackRenderState.method_70946((Object)j);
        }
        this.setProperties(stack, stackRenderState);
        renderLayer.method_67995(this.extents);
        renderLayer.method_67996(true);
        renderLayer.method_67994(this.baseModel.method_68511());
        renderLayer.method_67993(ITEM_TRANSFORMS.method_3503(displayContext));
        renderLayer.method_67997().addAll(this.baseModel.getQuads());
        SpecialRenderer specialRenderer = new SpecialRenderer();
        specialRenderer.setModelRenderParameters(aint, this.baseModel.getQuads());
        renderLayer.method_65617((class_10515)specialRenderer, (Object)specialRenderer.method_65704(stack));
    }

    private void setProperties(class_1799 stack, class_10444 stackRenderState) {
        BackpackDynamicModel.DynamicBlockStateModel dynamicBlockStateModel = this.baseModel;
        if (dynamicBlockStateModel instanceof BackpackDynamicModel.DynamicBlockStateModel) {
            BackpackDynamicModel.DynamicBlockStateModel backpackModel = dynamicBlockStateModel;
            backpackModel.isDyed = stack.method_57826(class_9334.field_49644);
            backpackModel.renderInfo = (RenderInfo)stack.method_58694(ModDataComponents.RENDER_INFO);
            backpackModel.sleepingBagColor = (Integer)stack.method_58695(ModDataComponents.SLEEPING_BAG_COLOR, (Object)class_1767.field_7964.method_7789());
            backpackModel.isSleepingBagDeployed = false;
            backpackModel.block = class_2248.method_9503((class_1792)stack.method_7909());
            if (backpackModel.renderInfo != null) {
                stackRenderState.method_70946((Object)"RenderInfo");
                stackRenderState.method_70946((Object)backpackModel.renderInfo.hasTanks());
                stackRenderState.method_70946((Object)"LeftTank");
                stackRenderState.method_70946((Object)backpackModel.renderInfo.getLeftFluidStack().fluidVariant().getFluid());
                stackRenderState.method_70946((Object)backpackModel.renderInfo.getLeftFluidStack().fluidVariant().getComponents());
                stackRenderState.method_70946((Object)backpackModel.renderInfo.getLeftFluidStack().getAmount());
                stackRenderState.method_70946((Object)"RightTank");
                stackRenderState.method_70946((Object)backpackModel.renderInfo.getRightFluidStack().fluidVariant().getFluid());
                stackRenderState.method_70946((Object)backpackModel.renderInfo.getRightFluidStack().fluidVariant().getComponents());
                stackRenderState.method_70946((Object)backpackModel.renderInfo.getRightFluidStack().getAmount());
            }
            if (backpackModel.sleepingBagColor != class_1767.field_7964.method_7789()) {
                stackRenderState.method_70946((Object)"SleepingBagColor");
                stackRenderState.method_70946((Object)backpackModel.sleepingBagColor);
            }
        }
    }

    public static class SpecialRenderer
    implements class_10508 {
        private int[] tintLayers;
        private List<class_777> baseModel;

        public void method_65699(class_811 displayContext, class_4587 poseStack, class_4597 buffer, int combinedLight, int packedOverlay, boolean hasFoil) {
            class_918.method_62476((class_811)displayContext, (class_4587)poseStack, (class_4597)buffer, (int)combinedLight, (int)packedOverlay, (int[])this.tintLayers, this.baseModel, (class_1921)class_4722.method_29382(), (class_10444.class_10445)(hasFoil ? class_10444.class_10445.field_55342 : class_10444.class_10445.field_55341));
        }

        public void setModelRenderParameters(int[] tintLayers, List<class_777> baseModel) {
            this.tintLayers = tintLayers;
            this.baseModel = baseModel;
        }

        public void method_72175(Set<Vector3f> set) {
        }
    }

    public record Unbaked(class_2960 base, List<class_10401> tintSources) implements class_10439.class_10441
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2960.field_25139.fieldOf("base").forGetter(Unbaked::base), (App)class_10402.field_55234.listOf().optionalFieldOf("tintSources", List.of()).forGetter(Unbaked::tintSources)).apply((Applicative)builder, Unbaked::new));

        public MapCodec<? extends class_10439.class_10441> method_65585() {
            return MAP_CODEC;
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            class_10819 resolved = context.comp_3390().method_45872(this.base);
            class_1100 class_11002 = resolved.method_68031();
            if (class_11002 instanceof BackpackDynamicModel) {
                BackpackDynamicModel baseModel = (BackpackDynamicModel)class_11002;
                return new BackpackItemModel(baseModel.bakeBlockStateModel(context.comp_3390(), resolved, (class_3665)class_1086.field_5350), this.tintSources);
            }
            throw new IllegalStateException("Expected BackpackDynamicModel, instead received " + resolved.getClass().getName());
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(this.base);
        }
    }
}

