/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory.ecosystem;

import cz.mcsworld.eroded.config.territory.TerritoryConfig;
import cz.mcsworld.eroded.world.territory.TerritoryCell;
import cz.mcsworld.eroded.world.territory.TerritoryCellKey;
import cz.mcsworld.eroded.world.territory.TerritoryThreatResolver;
import cz.mcsworld.eroded.world.territory.TerritoryWorldState;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public final class TerritoryEcosystemTicker {
    private static final int FALLBACK_INTERVAL_TICKS = 20;
    private static int rrIndex = 0;
    private static int tickCounter = 0;

    private TerritoryEcosystemTicker() {
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(TerritoryEcosystemTicker::onTick);
    }

    private static void onTick(MinecraftServer server) {
        int interval;
        TerritoryConfig root = TerritoryConfig.get();
        TerritoryConfig.Server cfg = root.server;
        if (!cfg.enabled || !cfg.ecosystemEnabled) {
            return;
        }
        int n = interval = cfg.ecosystemIntervalTicks > 0 ? cfg.ecosystemIntervalTicks : 20;
        if (++tickCounter < interval) {
            return;
        }
        tickCounter = 0;
        for (class_3218 world : server.method_3738()) {
            TerritoryEcosystemTicker.tickWorld(world);
        }
    }

    private static void tickWorld(class_3218 world) {
        TerritoryConfig.Server cfg = TerritoryConfig.get().server;
        List players = world.method_18456();
        if (players.isEmpty()) {
            return;
        }
        long tick = world.method_8503().method_3780();
        class_5819 random = world.method_8409();
        TerritoryWorldState state = TerritoryWorldState.get(world);
        int radius = Math.max(8, cfg.ecosystemVisibleRadiusBlocks);
        int maxPlayers = Math.max(1, cfg.ecosystemMaxPlayersPerSlice);
        int attemptsPerPlayer = Math.max(0, cfg.ecosystemAttemptsPerPlayer);
        int surfaceAttempts = Math.max(0, cfg.ecosystemSurfaceAttempts);
        int leafAttempts = Math.max(0, cfg.ecosystemLeafAttempts);
        if (attemptsPerPlayer <= 0 && surfaceAttempts <= 0 && leafAttempts <= 0) {
            return;
        }
        if (surfaceAttempts + leafAttempts <= 0) {
            surfaceAttempts = attemptsPerPlayer;
            leafAttempts = 0;
        }
        int leafMinY = Math.min(cfg.ecosystemLeafMinY, cfg.ecosystemLeafMaxY);
        int leafMaxY = Math.max(cfg.ecosystemLeafMinY, cfg.ecosystemLeafMaxY);
        float degradeThr = cfg.ecosystemDegradeThreatThreshold;
        int count = Math.min(maxPlayers, players.size());
        for (int i = 0; i < count; ++i) {
            int a;
            boolean doRegen;
            boolean recentlyMining;
            int idx = rrIndex++ % players.size();
            class_3222 player = (class_3222)players.get(idx);
            class_1923 cp = new class_1923(player.method_24515());
            TerritoryCellKey key = TerritoryCellKey.fromChunk(cp.field_9181, cp.field_9180);
            TerritoryCell cell = state.getOrCreateCell(key);
            float threat = TerritoryThreatResolver.computeThreat(cell, tick);
            int pollution = cell.getPollution(tick);
            int miningScore = cell.getMiningScore();
            long lastMiningTick = cell.getLastMiningActivityTick();
            long ticksSinceMining = lastMiningTick == 0L ? Integer.MAX_VALUE : tick - lastMiningTick;
            int calmDownDelay = cfg.ecosystemCalmDownDelay;
            boolean bl = recentlyMining = ticksSinceMining < (long)calmDownDelay;
            if (threat < 0.1f && pollution < 10) continue;
            boolean doDegrade = threat > degradeThr && recentlyMining;
            boolean bl2 = doRegen = !recentlyMining;
            if (!doDegrade && !doRegen) continue;
            class_2338 center = player.method_24515();
            if (doDegrade) {
                for (a = 0; a < surfaceAttempts; ++a) {
                    TerritoryEcosystemTicker.maybeDegradeSurfaceNearPlayer(world, center, radius, random);
                }
                for (a = 0; a < leafAttempts; ++a) {
                    TerritoryEcosystemTicker.maybeWitherLeavesNearPlayer(world, center, radius, leafMinY, leafMaxY, random, cfg);
                }
                continue;
            }
            cell.addForestation(1, tick);
            cell.addPollution(-1, tick);
            cell.addMining(-1, tick);
            for (a = 0; a < surfaceAttempts; ++a) {
                TerritoryEcosystemTicker.maybeRegrowNearPlayer(world, center, radius, random);
            }
        }
    }

    private static void maybeDegradeSurfaceNearPlayer(class_3218 world, class_2338 center, int radius, class_5819 random) {
        TerritoryConfig.Server cfg = TerritoryConfig.get().server;
        if (random.method_43057() > cfg.grassDegradeChance) {
            return;
        }
        class_2338 groundPos = TerritoryEcosystemTicker.randomSurfaceNearPlayer(world, center, radius, random);
        if (groundPos == null) {
            return;
        }
        class_2680 old = world.method_8320(groundPos);
        class_2680 newState = null;
        if (old.method_27852(class_2246.field_10219)) {
            newState = class_2246.field_10566.method_9564();
        } else if (old.method_27852(class_2246.field_10566)) {
            newState = class_2246.field_10253.method_9564();
        } else if (old.method_27852(class_2246.field_10253) && random.method_43057() < 0.2f) {
            newState = class_2246.field_10520.method_9564();
        } else if (old.method_27852(class_2246.field_28681) && random.method_43057() < 0.6f) {
            newState = class_2246.field_10566.method_9564();
        } else if (old.method_27852(class_2246.field_10520) && random.method_43057() < 0.1f) {
            newState = class_2246.field_10566.method_9564();
        }
        if (newState != null && newState != old) {
            world.method_8652(groundPos, newState, 2);
        }
        if (random.method_43057() < 0.7f) {
            class_2338 above = groundPos.method_10084();
            class_2680 a = world.method_8320(above);
            if (a.method_26215()) {
                return;
            }
            world.method_22352(above, false);
        }
    }

    private static void maybeRegrowNearPlayer(class_3218 world, class_2338 center, int radius, class_5819 random) {
        TerritoryConfig.Server cfg = TerritoryConfig.get().server;
        if (random.method_43057() > cfg.grassRegrowChance) {
            return;
        }
        class_2338 pos = TerritoryEcosystemTicker.randomSurfaceNearPlayer(world, center, radius, random);
        if (pos == null) {
            return;
        }
        if (world.method_22339(pos.method_10084()) < 9) {
            return;
        }
        class_2680 old = world.method_8320(pos);
        if (old.method_27852(class_2246.field_10566) || old.method_27852(class_2246.field_10253)) {
            world.method_8652(pos, class_2246.field_10219.method_9564(), 2);
        }
    }

    private static void maybeWitherLeavesNearPlayer(class_3218 world, class_2338 center, int radius, int leafMinY, int leafMaxY, class_5819 random, TerritoryConfig.Server cfg) {
        float leafAttemptChance = cfg.permanentScarChance * cfg.ecosystemLeafLossMultiplier;
        leafAttemptChance = Math.max(cfg.ecosystemLeafLossMinChance, leafAttemptChance);
        leafAttemptChance = Math.min(cfg.ecosystemLeafLossMaxChance, leafAttemptChance);
        if (random.method_43057() > leafAttemptChance) {
            return;
        }
        class_2338 base = TerritoryEcosystemTicker.randomSurfaceNearPlayer(world, center, radius, random);
        if (base == null) {
            return;
        }
        for (int y = 2; y <= 20; ++y) {
            class_2338 checkPos = base.method_10086(y);
            class_2680 state = world.method_8320(checkPos);
            if (state.method_26215()) continue;
            world.method_22352(checkPos, false);
            return;
        }
    }

    private static class_2338 randomSurfaceNearPlayer(class_3218 world, class_2338 center, int radius, class_5819 random) {
        int z;
        int x = center.method_10263() + random.method_43048(radius * 2 + 1) - radius;
        int y = world.method_8624(class_2902.class_2903.field_13203, x, z = center.method_10260() + random.method_43048(radius * 2 + 1) - radius) - 1;
        if (y < world.method_31607()) {
            return null;
        }
        return new class_2338(x, y, z);
    }
}

