/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cz.mcsworld.eroded.world.territory.TerritoryCell;
import cz.mcsworld.eroded.world.territory.TerritoryCellKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_3218;

public final class TerritoryWorldState
extends class_18 {
    private static final String ID = "eroded_territory";
    private final Map<TerritoryCellKey, TerritoryCell> cells = new HashMap<TerritoryCellKey, TerritoryCell>();
    private static final Codec<CellEntry> CELL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(CellEntry::x), (App)Codec.INT.fieldOf("z").forGetter(CellEntry::z), (App)Codec.INT.fieldOf("miningScore").forGetter(CellEntry::miningScore), (App)Codec.INT.fieldOf("mining").forGetter(CellEntry::mining), (App)Codec.INT.fieldOf("pollution").forGetter(CellEntry::pollution), (App)Codec.INT.fieldOf("forestation").forGetter(CellEntry::forestation), (App)Codec.LONG.fieldOf("lastTick").forGetter(CellEntry::lastTick)).apply((Applicative)instance, CellEntry::new));
    private static final Codec<TerritoryWorldState> CODEC = Codec.list(CELL_ENTRY_CODEC).fieldOf("cells").codec().xmap(entries -> {
        TerritoryWorldState state = new TerritoryWorldState();
        for (CellEntry e : entries) {
            TerritoryCell cell = new TerritoryCell();
            cell.setMiningScore(e.miningScore());
            cell.setMining(e.mining());
            cell.setPollution(e.pollution());
            cell.setForestation(e.forestation());
            cell.setLastTick(e.lastTick());
            state.cells.put(new TerritoryCellKey(e.x(), e.z()), cell);
        }
        return state;
    }, state -> {
        ArrayList<CellEntry> entries = new ArrayList<CellEntry>(state.cells.size());
        for (Map.Entry<TerritoryCellKey, TerritoryCell> entry : state.cells.entrySet()) {
            TerritoryCellKey key = entry.getKey();
            TerritoryCell cell = entry.getValue();
            entries.add(new CellEntry(key.cellX(), key.cellZ(), cell.getMiningScore(), cell.getMiningRaw(), cell.getPollutionRaw(), cell.getForestationRaw(), cell.getLastTick()));
        }
        return entries;
    });
    public static final class_10741<TerritoryWorldState> TYPE = new class_10741("eroded_territory", TerritoryWorldState::new, CODEC, null);

    public static TerritoryWorldState get(class_3218 world) {
        return (TerritoryWorldState)world.method_17983().method_17924(TYPE);
    }

    public TerritoryCell getOrCreateCell(TerritoryCellKey key) {
        return this.cells.computeIfAbsent(key, k -> new TerritoryCell());
    }

    public boolean hasCells() {
        return !this.cells.isEmpty();
    }

    public Map<TerritoryCellKey, TerritoryCell> getCells() {
        return this.cells;
    }

    private record CellEntry(int x, int z, int miningScore, int mining, int pollution, int forestation, long lastTick) {
    }
}

