/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory;

import cz.mcsworld.eroded.config.territory.TerritoryConfig;
import cz.mcsworld.eroded.world.territory.TerritoryCell;
import cz.mcsworld.eroded.world.territory.TerritoryCellKey;
import cz.mcsworld.eroded.world.territory.TerritoryThreatResolver;
import cz.mcsworld.eroded.world.territory.TerritoryWorldState;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1923;
import net.minecraft.class_2902;
import net.minecraft.class_5134;

public final class TerritoryMobSpawnHandler {
    private static final String TAG = "eroded_territory_threat";

    private TerritoryMobSpawnHandler() {
    }

    public static void register() {
        TerritoryConfig.Server cfg = TerritoryConfig.get().server;
        if (!cfg.enabled || !cfg.mobBuffEnabled) {
            return;
        }
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (!(entity instanceof class_1588)) {
                return;
            }
            class_1588 mob = (class_1588)entity;
            if (mob.method_5752().contains(TAG)) {
                return;
            }
            long tick = world.method_8503().method_3780();
            class_1923 cp = new class_1923(mob.method_24515());
            TerritoryWorldState worldState = TerritoryWorldState.get(world);
            TerritoryCellKey key = TerritoryCellKey.fromChunk(cp.field_9181, cp.field_9180);
            TerritoryCell cell = worldState.getOrCreateCell(key);
            float threat = TerritoryThreatResolver.computeThreat(cell, tick);
            if (cfg.mobSpawnControlEnabled) {
                if (cfg.surfaceOnlySpawns) {
                    int x = mob.method_24515().method_10263();
                    int z = mob.method_24515().method_10260();
                    int surfaceY = world.method_8624(class_2902.class_2903.field_13203, x, z);
                    if (mob.method_24515().method_10264() < surfaceY - cfg.undergroundTolerance) {
                        mob.method_31472();
                        return;
                    }
                }
                float t0 = cfg.mobBuffThreshold;
                float tN = TerritoryMobSpawnHandler.clamp((threat - t0) / (1.0f - t0), 0.0f, 1.0f);
                float keepChance = 1.0f - tN * (1.0f - cfg.spawnKeepMinChance);
                if (world.field_9229.method_43057() > keepChance) {
                    mob.method_31472();
                    return;
                }
            }
            if (threat < cfg.mobBuffThreshold) {
                return;
            }
            TerritoryMobSpawnHandler.applyBuffs(mob, threat, cfg);
            mob.method_5780(TAG);
        });
    }

    private static void applyBuffs(class_1588 mob, float threat, TerritoryConfig.Server cfg) {
        class_1324 dmg;
        float t0 = cfg.mobBuffThreshold;
        float tN = TerritoryMobSpawnHandler.clamp((threat - t0) / (1.0f - t0), 0.0f, 1.0f);
        double hp = 20.0 + (cfg.mobMaxHp - 20.0) * (double)tN;
        class_1324 maxHp = mob.method_5996(class_5134.field_23716);
        if (maxHp != null) {
            maxHp.method_6192(hp);
            mob.method_6033((float)hp);
        }
        if ((dmg = mob.method_5996(class_5134.field_23721)) != null) {
            dmg.method_6192(3.0 + (double)tN * 6.0);
        }
        if (threat > 0.55f) {
            mob.method_6092(new class_1293(class_1294.field_5910, Integer.MAX_VALUE, threat > 0.8f ? 1 : 0, true, false));
        }
        if (threat > 0.65f) {
            mob.method_6092(new class_1293(class_1294.field_5904, Integer.MAX_VALUE, 0, true, false));
        }
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }
}

