/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.server.spawn;

import cz.mcsworld.eroded.config.territory.TerritoryConfig;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5354;

public final class SpawnProtectionSystem {
    private SpawnProtectionSystem() {
    }

    public static void tick(class_3218 world) {
        TerritoryConfig root = TerritoryConfig.get();
        TerritoryConfig.Server cfg = root.server;
        if (!cfg.enabled || !cfg.spawnProtectionEnabled) {
            return;
        }
        int radius = cfg.spawnProtectionRadius;
        int radiusSq = radius * radius;
        int checkRange = radius + 24;
        class_2338 spawn = world.method_43126();
        for (class_3222 player : world.method_18456()) {
            if (player.method_68878() || player.method_7325()) continue;
            boolean playerInSpawn = SpawnProtectionSystem.isInSpawn(player.method_24515(), spawn, radiusSq);
            player.method_5684(playerInSpawn);
        }
        class_238 spawnBox = new class_238(spawn).method_1014((double)checkRange);
        for (class_1308 mob : world.method_8390(class_1308.class, spawnBox, e -> e.method_5805() && e instanceof class_1569)) {
            class_3222 targetPlayer;
            if (SpawnProtectionSystem.isInSpawn(mob.method_24515(), spawn, radiusSq)) {
                SpawnProtectionSystem.pushMobOut(mob, spawn, radius);
                continue;
            }
            class_1309 target = mob.method_5968();
            if (!(target instanceof class_3222) || !SpawnProtectionSystem.isInSpawn((targetPlayer = (class_3222)target).method_24515(), spawn, radiusSq)) continue;
            mob.method_5980(null);
            mob.method_19540(false);
            if (!(mob instanceof class_5354)) continue;
            class_5354 angerable = (class_5354)mob;
            angerable.method_29922();
        }
    }

    private static boolean isInSpawn(class_2338 pos, class_2338 spawn, int radiusSq) {
        return pos.method_10262((class_2382)spawn) <= (double)radiusSq;
    }

    private static void pushMobOut(class_1308 mob, class_2338 spawn, int radius) {
        class_243 center;
        class_243 mobPos = mob.method_19538();
        class_243 direction = mobPos.method_1020(center = class_243.method_24953((class_2382)spawn));
        if (direction.method_1027() == 0.0) {
            direction = new class_243(1.0, 0.0, 0.0);
        }
        class_243 normalized = direction.method_1029();
        class_243 escapePos = center.method_1019(normalized.method_1021((double)(radius + 6)));
        mob.method_5980(null);
        mob.method_19540(false);
        mob.method_5942().method_6337(escapePos.field_1352, escapePos.field_1351, escapePos.field_1350, 1.2);
    }

    public static boolean isPlayerInSpawn(class_3222 player) {
        TerritoryConfig.Server cfg = TerritoryConfig.get().server;
        if (!cfg.enabled || !cfg.spawnProtectionEnabled) {
            return false;
        }
        class_3218 world = player.method_51469();
        int radius = cfg.spawnProtectionRadius;
        int radiusSq = radius * radius;
        return SpawnProtectionSystem.isInSpawn(player.method_24515(), world.method_43126(), radiusSq);
    }
}

