/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.gui;

import cz.mcsworld.eroded.client.data.ErodedCompassClientData;
import cz.mcsworld.eroded.death.ErodedCompassItem;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public final class ErodedCompassTooltip {
    private static long lastStableSeconds = -1L;
    private static String cachedTime = null;
    private static long lastTargetLong = Long.MIN_VALUE;
    private static final long JITTER_SECONDS = 1L;
    private static final long RESET_JUMP_SECONDS = 5L;

    private ErodedCompassTooltip() {
    }

    public static void register() {
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            if (stack.method_7960()) {
                return;
            }
            if (!(stack.method_7909() instanceof ErodedCompassItem)) {
                return;
            }
            if (!ErodedCompassClientData.isActive()) {
                ErodedCompassTooltip.resetCache();
                return;
            }
            long ticks = ErodedCompassClientData.getRemainingTicks();
            if (ticks <= 0L) {
                return;
            }
            class_2338 target = ErodedCompassClientData.getTarget();
            if (target == null) {
                return;
            }
            long targetLong = target.method_10063();
            if (targetLong != lastTargetLong) {
                ErodedCompassTooltip.resetCache();
                lastTargetLong = targetLong;
            }
            long seconds = ticks / 20L;
            if (cachedTime == null || lastStableSeconds < 0L) {
                ErodedCompassTooltip.setCached(seconds);
            } else if (seconds < lastStableSeconds) {
                ErodedCompassTooltip.setCached(seconds);
            } else {
                long diff = seconds - lastStableSeconds;
                if (diff > 1L && diff >= 5L) {
                    ErodedCompassTooltip.setCached(seconds);
                }
            }
            if (cachedTime == null) {
                return;
            }
            lines.add(class_2561.method_43470((String)""));
            lines.add(class_2561.method_43471((String)"eroded.compass.tooltip.header").method_27692(class_124.field_1080));
            lines.add(class_2561.method_43469((String)"eroded.compass.tooltip.time", (Object[])new Object[]{cachedTime}).method_27692(class_124.field_1065));
            lines.add(class_2561.method_43469((String)"eroded.compass.tooltip.coords", (Object[])new Object[]{target.method_10263(), target.method_10264(), target.method_10260()}).method_27692(class_124.field_1063));
        });
    }

    private static void setCached(long seconds) {
        lastStableSeconds = Math.max(0L, seconds);
        long min = lastStableSeconds / 60L;
        long sec = lastStableSeconds % 60L;
        cachedTime = String.format("%02d:%02d", min, sec);
    }

    private static void resetCache() {
        lastStableSeconds = -1L;
        cachedTime = null;
        lastTargetLong = Long.MIN_VALUE;
    }
}

