/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.death;

import com.mojang.authlib.GameProfile;
import cz.mcsworld.eroded.config.death.DeathConfig;
import cz.mcsworld.eroded.core.ErodedItems;
import cz.mcsworld.eroded.death.DeathChestState;
import cz.mcsworld.eroded.death.DeathHologramHandler;
import cz.mcsworld.eroded.death.DeathValueCalculator;
import cz.mcsworld.eroded.death.ErodedCompassHandler;
import cz.mcsworld.eroded.death.ErodedDeathMemory;
import cz.mcsworld.eroded.death.ErodedDeathStorage;
import cz.mcsworld.eroded.death.block.ErodedBlocks;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeathChestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ErodedDeath");

    public static void register() {
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                boolean isInvulnerable = player.method_5679(player.method_51469(), source);
                if (amount >= player.method_6032() && !isInvulnerable && !DeathChestHandler.hasTotem(player)) {
                    LOGGER.info("Detekov\u00e1no fat\u00e1ln\u00ed po\u0161kozen\u00ed pro {} (P\u0159\u00ed\u010dina: {}). Z\u00e1lohuji invent\u00e1\u0159.", (Object)player.method_5477().getString(), (Object)source.method_5525());
                    DeathChestHandler.handleDeath(player);
                }
            }
            return true;
        });
    }

    private static boolean hasTotem(class_3222 player) {
        return player.method_6047().method_31574(class_1802.field_8288) || player.method_6079().method_31574(class_1802.field_8288);
    }

    private static void handleDeath(class_3222 player) {
        class_3218 world = player.method_51469();
        ArrayList<class_1799> snapshot = new ArrayList<class_1799>();
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960()) continue;
            if (!stack.method_31574(ErodedItems.DEATH_COMPASS)) {
                snapshot.add(stack.method_7972());
            }
            player.method_31548().method_5447(i, class_1799.field_8037);
        }
        if (snapshot.isEmpty()) {
            return;
        }
        UUID hologramId = UUID.randomUUID();
        class_2338 deathPos = player.method_24515().method_10062();
        UUID playerUuid = player.method_5667();
        GameProfile gameProfile = player.method_7334();
        new Thread(() -> {
            try {
                Thread.sleep(250L);
                world.method_8503().execute(() -> {
                    try {
                        class_2338 chestPos = DeathChestHandler.findSurfacePos(world, deathPos);
                        world.method_8652(chestPos, ErodedBlocks.DEATH_ENDER_CHEST.method_9564(), 3);
                        long deathValue = DeathValueCalculator.calculate(snapshot);
                        long baseTimeMs = (long)DeathConfig.get().chest.protectionTicks * 50L;
                        long untilEpochMs = System.currentTimeMillis() + baseTimeMs;
                        ErodedDeathMemory memory = new ErodedDeathMemory(chestPos, (class_5321<class_1937>)world.method_27983(), untilEpochMs, deathValue, hologramId);
                        ErodedDeathStorage.putIfMoreValuable(playerUuid, memory);
                        Map<Integer, DeathChestState.StoredStack> stored = DeathChestState.fromInventory(snapshot);
                        DeathChestState.get(world).put(chestPos, playerUuid, untilEpochMs, stored, hologramId);
                        ErodedCompassHandler.onPlayerDeath(player, chestPos, true);
                        DeathHologramHandler.spawn(world, chestPos, gameProfile, (int)(baseTimeMs / 1000L), hologramId);
                    }
                    catch (Exception e) {
                        LOGGER.error("Chyba v odlo\u017een\u00e9m z\u00e1pisu: ", (Throwable)e);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    private static class_2338 findSurfacePos(class_3218 world, class_2338 startPos) {
        class_2338.class_2339 mutable = startPos.method_25503();
        while (world.method_8320((class_2338)mutable).method_26215() && mutable.method_10264() > world.method_31607()) {
            mutable.method_10100(0, -1, 0);
        }
        return mutable.method_10264() < startPos.method_10264() ? mutable.method_10084().method_10062() : startPos;
    }
}

