/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.crafting;

import cz.mcsworld.eroded.config.crafting.CraftingConfig;
import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.crafting.CraftingCgResolver;
import cz.mcsworld.eroded.crafting.CraftingQualityApplier;
import cz.mcsworld.eroded.crafting.CraftingSkillResolver;
import cz.mcsworld.eroded.crafting.InputQualityResolver;
import cz.mcsworld.eroded.crafting.Quality;
import cz.mcsworld.eroded.crafting.QualityApplicable;
import cz.mcsworld.eroded.crafting.QualityResolver;
import cz.mcsworld.eroded.crafting.RecipeDifficulty;
import cz.mcsworld.eroded.crafting.RecipeDifficultyResolver;
import cz.mcsworld.eroded.crafting.context.CraftingContext;
import cz.mcsworld.eroded.energy.EnergyCostResolver;
import cz.mcsworld.eroded.network.CraftingFailPacket;
import cz.mcsworld.eroded.network.EnergySyncPacket;
import cz.mcsworld.eroded.network.SafeNetworkUtil;
import cz.mcsworld.eroded.skills.SkillData;
import cz.mcsworld.eroded.skills.SkillManager;
import cz.mcsworld.eroded.skills.SkillType;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public final class CraftingService {
    private CraftingService() {
    }

    public static boolean process(CraftingContext context, class_1799 result) {
        CraftingConfig cfg = CraftingConfig.get();
        if (!cfg.enabled) {
            return true;
        }
        class_3222 player = context.getPlayer();
        SkillData data = SkillManager.get(player);
        EnergyConfig root = EnergyConfig.get();
        EnergyConfig.Server.Core energyCfg = root.server.core;
        float avgInputQuality = InputQualityResolver.resolveAverage(context.getInputs());
        RecipeDifficulty difficulty = RecipeDifficultyResolver.resolve(result);
        boolean applyQuality = QualityApplicable.isApplicable(result);
        float diffEnergyMult = switch (difficulty) {
            default -> throw new MatchException(null, null);
            case RecipeDifficulty.SIMPLE -> cfg.energy.simpleRecipeEnergyMultiplier;
            case RecipeDifficulty.NORMAL -> cfg.energy.normalRecipeEnergyMultiplier;
            case RecipeDifficulty.COMPLEX -> cfg.energy.complexRecipeEnergyMultiplier;
        };
        int rawBase = EnergyCostResolver.getBaseCraftingCostFromInputs(context.getInputs());
        int baseCost = Math.round((float)rawBase * diffEnergyMult);
        Quality quality = Quality.STANDARD;
        if (cfg.quality.enabled && applyQuality) {
            quality = QualityResolver.resolveQuality(data, avgInputQuality);
        }
        float qualityEnergyMult = switch (quality) {
            default -> throw new MatchException(null, null);
            case Quality.POOR -> cfg.energy.poorQualityEnergyMultiplier;
            case Quality.STANDARD -> cfg.energy.standardQualityEnergyMultiplier;
            case Quality.EXCELLENT -> cfg.energy.excellentQualityEnergyMultiplier;
        };
        int energyCost = Math.max(cfg.energy.minimumCraftCost, Math.round((float)baseCost * qualityEnergyMult));
        if (!cfg.energy.enabled) {
            energyCost = 0;
        }
        if (!data.canAffordEnergy(energyCost) && energyCfg.blockWorkAtZero) {
            SafeNetworkUtil.safeSend(player, new CraftingFailPacket());
            return false;
        }
        data.consumeEnergy(energyCost);
        SafeNetworkUtil.safeSend(player, new EnergySyncPacket(data.getEnergy()));
        if (cfg.cg.enabled) {
            SkillType skill = CraftingSkillResolver.resolve(result);
            float baseCg = CraftingCgResolver.getBaseCg(result);
            float diffCgMult = switch (difficulty) {
                default -> throw new MatchException(null, null);
                case RecipeDifficulty.SIMPLE -> cfg.cg.simpleRecipeCgMultiplier;
                case RecipeDifficulty.NORMAL -> cfg.cg.normalRecipeCgMultiplier;
                case RecipeDifficulty.COMPLEX -> cfg.cg.complexRecipeCgMultiplier;
            };
            data.addCg(skill, baseCg * diffCgMult);
        }
        if (cfg.quality.enabled && applyQuality) {
            CraftingQualityApplier.apply(result, quality);
        }
        return true;
    }
}

