/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.client.hud;

import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.skills.SkillData;

public final class EnergyHudLogic {
    public static final int GREEN = -13710223;
    public static final int YELLOW = -733121;
    public static final int ORANGE = -1671646;
    public static final int RED = -43691;
    public static final int EMPTY = -11184811;
    public static final String WARN_TIRED = "eroded.energy.state.tired";
    public static final String WARN_EXHAUSTED = "eroded.energy.state.exhausted";
    public static final String WARN_EMPTY = "eroded.energy.state.empty";

    private EnergyHudLogic() {
    }

    public static SegmentVisual resolve(int index, int total, int energy, int maxEnergy, boolean isRegenerating, int ticks) {
        boolean blink;
        boolean isRegenIcon;
        boolean visible;
        EnergyConfig root = EnergyConfig.get();
        EnergyConfig.Server.HudThresholds cfg = root.server.hudThresholds;
        if (maxEnergy <= 0) {
            return new SegmentVisual(false, -11184811, 1.0f);
        }
        float ratio = (float)energy / (float)maxEnergy;
        float percent = ratio * 100.0f;
        if (percent <= 1.0f && !isRegenerating) {
            return new SegmentVisual(false, -11184811, 1.0f);
        }
        float thresholdForThisIcon = (float)index / (float)total * 100.0f;
        float thresholdForNextIcon = (float)(index + 1) / (float)total * 100.0f;
        boolean bl = visible = percent > thresholdForThisIcon;
        if (!visible) {
            return new SegmentVisual(false, -11184811, 1.0f);
        }
        boolean blinkOn = ticks / 10 % 2 == 0;
        boolean baseBlink = percent <= cfg.blinkBelowPercent;
        int lastActiveIndex = (int)(ratio * (float)total);
        boolean isLeadingIcon = index == lastActiveIndex;
        boolean bl2 = isRegenIcon = isRegenerating && isLeadingIcon;
        boolean bl3 = isRegenIcon ? percent <= cfg.blinkBelowPercent : (blink = isLeadingIcon && baseBlink);
        if (blink && !blinkOn) {
            return new SegmentVisual(false, -11184811, 1.0f);
        }
        int color = isRegenIcon ? -733121 : EnergyHudLogic.baseColorByPercent(percent);
        float scale = 1.0f;
        if (isRegenIcon) {
            float pulse = (float)Math.sin((double)((float)(ticks % 20) / 20.0f) * Math.PI);
            scale = 1.0f + 0.16f * pulse;
        }
        return new SegmentVisual(true, color, scale);
    }

    public static String getWarningTranslationKey(SkillData.EnergyState state) {
        return switch (state) {
            case SkillData.EnergyState.TIRED -> WARN_TIRED;
            case SkillData.EnergyState.EXHAUSTED -> WARN_EXHAUSTED;
            case SkillData.EnergyState.EMPTY -> WARN_EMPTY;
            default -> null;
        };
    }

    private static int baseColorByPercent(float percent) {
        EnergyConfig root = EnergyConfig.get();
        EnergyConfig.Server.HudThresholds cfg = root.server.hudThresholds;
        if (percent >= cfg.greenFromPercent) {
            return -13710223;
        }
        if (percent >= cfg.yellowFromPercent) {
            return -733121;
        }
        if (percent >= cfg.orangeFromPercent) {
            return -1671646;
        }
        return -43691;
    }

    public record SegmentVisual(boolean visible, int color, float scale) {
    }
}

