/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.client.hud;

import cz.mcsworld.eroded.client.data.ClientEnergyData;
import cz.mcsworld.eroded.client.hud.EnergyHudLogic;
import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.config.energy.EnergyHudPosition;
import cz.mcsworld.eroded.skills.SkillData;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class EnergyHud
implements HudRenderCallback {
    private static final String ICON = "\u26a1";
    private static int lastEnergyValue = -1;
    private static boolean isRegenerating = false;
    private static int warningTicks = 0;
    private static SkillData.EnergyState activeWarningState = null;

    public static void triggerWarning(SkillData.EnergyState state) {
        if (state == null || state == SkillData.EnergyState.NORMAL) {
            return;
        }
        activeWarningState = state;
        warningTicks = EnergyConfig.get().client.hud.warningMessageTime;
    }

    public static void resetWarning() {
        warningTicks = 0;
        activeWarningState = null;
    }

    public void onHudRender(class_332 context, class_9779 tickCounter) {
        int x;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || !ClientEnergyData.isInitialized()) {
            return;
        }
        EnergyConfig root = EnergyConfig.get();
        EnergyConfig.Client.Hud cfg = root.client.hud;
        if (!cfg.energyHudEnabled) {
            return;
        }
        int energy = ClientEnergyData.getEnergy();
        int maxEnergy = ClientEnergyData.getMaxEnergy();
        if (maxEnergy <= 0) {
            maxEnergy = root.server.core.maxEnergy;
        }
        if (energy > lastEnergyValue && lastEnergyValue != -1) {
            isRegenerating = true;
        } else if (energy < lastEnergyValue) {
            isRegenerating = false;
        }
        if (energy >= maxEnergy) {
            isRegenerating = false;
        }
        lastEnergyValue = energy;
        if (!cfg.showHudWhenFull && energy >= maxEnergy) {
            return;
        }
        int total = cfg.numberEnergyFlashes;
        int ticks = client.field_1705.method_1738();
        int screenW = context.method_51421();
        int screenH = context.method_51443();
        int spacing = 8;
        int hudWidth = total * spacing;
        int margin = cfg.hudMargin;
        int posIconHUD_Y = cfg.posIconHUD_Y;
        int posTextHUD_Y = cfg.posTextHUD_Y;
        int y = switch (cfg.hudPosition) {
            case EnergyHudPosition.CENTER_DOWN -> {
                x = (screenW - hudWidth) / 2;
                yield screenH - posIconHUD_Y;
            }
            case EnergyHudPosition.LEFT_DOWN -> {
                x = margin;
                yield screenH - posIconHUD_Y;
            }
            case EnergyHudPosition.RIGHT_DOWN -> {
                x = screenW - hudWidth - margin;
                yield screenH - posIconHUD_Y;
            }
            case EnergyHudPosition.LEFT_UP -> {
                x = margin;
                yield margin;
            }
            case EnergyHudPosition.CENTER_UP -> {
                x = (screenW - hudWidth) / 2;
                yield margin;
            }
            case EnergyHudPosition.RIGHT_UP -> {
                x = screenW - hudWidth - margin;
                yield margin;
            }
            default -> {
                x = (screenW - hudWidth) / 2;
                yield screenH - posIconHUD_Y;
            }
        };
        boolean hideIconsBecauseChat = client.field_1755 instanceof class_408;
        if (!hideIconsBecauseChat) {
            for (int i = 0; i < total; ++i) {
                int drawX = x + i * 8;
                EnergyHudLogic.SegmentVisual visual = EnergyHudLogic.resolve(i, total, energy, maxEnergy, isRegenerating, ticks);
                if (!visual.visible()) {
                    context.method_51433(client.field_1772, ICON, drawX, y, -11184811, true);
                    continue;
                }
                Matrix3x2fStack matrices = context.method_51448();
                matrices.pushMatrix();
                float cx = drawX + 4;
                float cy = y + 4;
                matrices.translate(cx, cy);
                matrices.scale(visual.scale(), visual.scale());
                matrices.translate(-cx, -cy);
                context.method_51433(client.field_1772, ICON, drawX, y, 0xFF000000 | visual.color() & 0xFFFFFF, true);
                matrices.popMatrix();
            }
        }
        if (warningTicks > 0 && !isRegenerating && root.server.warnings.warningsEnabled) {
            String key;
            String string = key = activeWarningState == null ? null : EnergyHudLogic.getWarningTranslationKey(activeWarningState);
            if (key != null) {
                class_5250 text = class_2561.method_43471((String)key);
                int textWidth = client.field_1772.method_27525((class_5348)text);
                int textX = (screenW - textWidth) / 2;
                int textY = y - posTextHUD_Y;
                int padding = 4;
                Objects.requireNonNull(client.field_1772);
                context.method_25294(textX - padding, textY - padding, textX + textWidth + padding, textY + 9 + padding, -872415232);
                context.method_51439(client.field_1772, (class_2561)text, textX, textY, -43691, true);
                if (--warningTicks <= 0) {
                    activeWarningState = null;
                }
            } else {
                warningTicks = 0;
                activeWarningState = null;
            }
        }
    }
}

