/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.client.data;

import cz.mcsworld.eroded.config.darkness.DarknessConfigs;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;

public final class DarknessClientData {
    private static float smoothedLocalDarkness = 0.0f;
    private static float smoothedEyeTarget = 0.0f;
    private static boolean darknessLatched = false;
    private static int lightGraceTicks = 0;
    private static float alpha = 0.0f;
    private static boolean hasServerState = false;
    private static int darknessStableTicks = 0;
    private static final int ENTER_STABLE_TICKS = 20;
    private static boolean wasInDarkness = false;
    public static boolean SHOW_DEBUG_PANEL = false;
    private static boolean serverInDarkness = false;

    private DarknessClientData() {
    }

    public static void update(boolean value) {
        hasServerState = true;
        wasInDarkness = serverInDarkness;
        serverInDarkness = value;
    }

    public static boolean isServerInDarkness() {
        return hasServerState && serverInDarkness;
    }

    public static boolean consumeDarknessExit() {
        boolean exited = wasInDarkness && !serverInDarkness;
        wasInDarkness = serverInDarkness;
        return exited;
    }

    public static float tickAndGetAlpha() {
        DarknessConfigs root = DarknessConfigs.get();
        if (!root.enabled) {
            return 0.0f;
        }
        DarknessConfigs.Client cfg = root.client;
        if (!cfg.visualDarknessEnabled) {
            return 0.0f;
        }
        float target = DarknessClientData.isServerInDarkness() ? 1.0f : 0.0f;
        float targetSmoothing = cfg.eyeSmoothing;
        smoothedEyeTarget += (target - smoothedEyeTarget) * targetSmoothing;
        float speed = Math.max(0.001f, cfg.fadeSpeed);
        if (alpha < smoothedEyeTarget) {
            alpha = Math.min(smoothedEyeTarget, alpha + speed);
        } else if (alpha > smoothedEyeTarget) {
            alpha = Math.max(smoothedEyeTarget, alpha - speed);
        }
        return alpha;
    }

    public static float getLocalLightDarkness() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return smoothedLocalDarkness;
        }
        DarknessConfigs root = DarknessConfigs.get();
        if (!root.enabled) {
            return 0.0f;
        }
        DarknessConfigs.Client cfg = root.client;
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        class_2338 basePos = player.method_24515();
        class_243 look = player.method_5828(1.0f);
        float totalBlockLight = 0.0f;
        int samples = cfg.samples;
        for (int i = 0; i < samples; ++i) {
            float dist = (float)(cfg.sampleStart + (double)i * cfg.sampleStep);
            class_2338 p = basePos.method_10069(class_3532.method_15357((double)(look.field_1352 * (double)dist)), class_3532.method_15357((double)(look.field_1351 * (double)dist)), class_3532.method_15357((double)(look.field_1350 * (double)dist)));
            totalBlockLight += (float)world.method_8314(class_1944.field_9282, p);
        }
        float avgBlock = totalBlockLight / (float)samples;
        if (avgBlock >= 12.0f) {
            smoothedLocalDarkness += (0.0f - smoothedLocalDarkness) * 0.4f;
            return smoothedLocalDarkness;
        }
        float blockDarkness = 1.0f - class_3532.method_15363((float)((avgBlock - 2.0f) / 7.0f), (float)0.0f, (float)1.0f);
        blockDarkness = (float)Math.pow(blockDarkness, cfg.blockCurve);
        smoothedLocalDarkness += (blockDarkness - smoothedLocalDarkness) * cfg.localSmoothing;
        return smoothedLocalDarkness;
    }

    public static float getSkyLimiter() {
        DarknessConfigs root = DarknessConfigs.get();
        if (!root.enabled) {
            return 1.0f;
        }
        DarknessConfigs.Client cfg = root.client;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return 1.0f;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        class_2338 pos = player.method_24515();
        int sky = world.method_8314(class_1944.field_9284, pos);
        float limiter = 1.0f - class_3532.method_15363((float)(((float)sky - 2.0f) / 11.0f), (float)0.0f, (float)1.0f);
        return (float)Math.pow(limiter, cfg.skyCurve);
    }

    public static float getBlockLightLimiter() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return 1.0f;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        class_2338 pos = player.method_24515();
        int block = world.method_8314(class_1944.field_9282, pos);
        float limiter = 1.0f - class_3532.method_15363((float)(((float)block - 2.0f) / 10.0f), (float)0.0f, (float)1.0f);
        return (float)Math.pow(limiter, 1.3f);
    }

    public static float getEyeAlphaDebug() {
        return alpha;
    }

    public static float getSmoothedLocalDarknessDebug() {
        return smoothedLocalDarkness;
    }

    public static boolean isDarknessActive() {
        DarknessConfigs root = DarknessConfigs.get();
        if (!root.enabled) {
            return false;
        }
        DarknessConfigs.Client cfg = root.client;
        if (!cfg.visualDarknessEnabled) {
            return false;
        }
        if (!hasServerState) {
            return false;
        }
        float local = DarknessClientData.getLocalLightDarkness();
        boolean current = serverInDarkness;
        if (current) {
            if (++darknessStableTicks >= 20) {
                darknessLatched = true;
                lightGraceTicks = 0;
                return true;
            }
            return false;
        }
        darknessStableTicks = 0;
        if (darknessLatched) {
            if (++lightGraceTicks < cfg.graceTicks) {
                return true;
            }
            darknessLatched = false;
            return false;
        }
        return false;
    }

    public static float getFrozenEyeAlpha() {
        return alpha;
    }
}

