/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3544;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import org.apache.commons.lang3.mutable.MutableObject;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.api.callback.JadeBeforeTooltipCollectCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.BoxElementImpl;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.RayTracing;
import snownee.jade.track.ProgressTracker;
import snownee.jade.util.ClientProxy;

public class WailaTickHandler {
    private String lastNarration = "";
    private long lastNarrationTime = 0L;
    public BoxElementImpl rootElement;
    public ProgressTracker progressTracker = new ProgressTracker();

    public void narrate(Element element, boolean dedupe) {
        if (System.currentTimeMillis() - this.lastNarrationTime < 500L) {
            return;
        }
        class_2561 component = element.cachedNarration();
        if (component == null) {
            return;
        }
        this.narrate(class_3544.method_15440((String)component.getString()), dedupe);
        this.lastNarrationTime = System.currentTimeMillis();
    }

    public void narrate(String message, boolean dedupe) {
        if (message.isEmpty()) {
            return;
        }
        if (dedupe && message.equals(this.lastNarration)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            class_333 narrator = class_310.method_1551().method_44713();
            narrator.method_37016(message);
            if (IWailaConfig.get().general().isDebug()) {
                Jade.LOGGER.info("Narrating: {}", (Object)message);
            }
            if (narrator.method_1791()) {
                narrator.method_1793();
                narrator.method_66522(message, true);
            }
        });
        this.lastNarration = message;
    }

    public void clearLastNarration() {
        this.lastNarration = "";
    }

    public void tickClient() {
        class_3965 blockTarget;
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            this.rootElement = null;
            this.progressTracker.clear();
            OverlayRenderer.clearState();
            return;
        }
        this.progressTracker.tick();
        IWailaConfig.General config = IWailaConfig.get().general();
        if (!config.shouldDisplayTooltip()) {
            this.rootElement = null;
            return;
        }
        if (JadeUI.isPinned()) {
            return;
        }
        if (!ClientProxy.shouldShowWithGui(mc, mc.field_1755)) {
            return;
        }
        class_1297 entity = mc.method_1560();
        if (entity == null) {
            this.rootElement = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        class_239 target = RayTracing.INSTANCE.getTarget();
        if (target == null) {
            this.rootElement = null;
            return;
        }
        Accessor<class_3966> accessor = null;
        if (target instanceof class_3965 && (blockTarget = (class_3965)target).method_17783() != class_239.class_240.field_1333) {
            class_2680 state = RayTracing.wrapBlock((class_1922)level, blockTarget, class_3726.method_16195((class_1297)entity));
            class_2586 tileEntity = level.method_8321(blockTarget.method_17777());
            accessor = WailaClientRegistration.instance().blockAccessor().blockState(state).blockEntity(tileEntity).hit(blockTarget).requireVerification().build();
        } else if (target instanceof class_3966) {
            class_3966 entityTarget = (class_3966)target;
            accessor = WailaClientRegistration.instance().entityAccessor().hit(entityTarget).entity(entityTarget.method_17782()).requireVerification().build();
        } else if (mc.field_1755 instanceof PreviewOptionsScreen) {
            accessor = WailaClientRegistration.instance().blockAccessor().blockState(class_2246.field_10219.method_9564()).hit(new class_3965(entity.method_19538(), class_2350.field_11036, entity.method_24515(), false)).build();
        }
        EntityAccessor originalAccessor = accessor;
        for (JadeRayTraceCallback callback : WailaClientRegistration.instance().rayTraceCallback.callbacks()) {
            accessor = callback.onRayTrace(target, accessor, originalAccessor);
        }
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.rootElement = null;
            return;
        }
        AccessorClientHandler<Accessor<?>> handler = WailaClientRegistration.instance().getAccessorHandler(accessor.getAccessorType());
        if (!handler.shouldDisplay(accessor)) {
            this.rootElement = null;
            return;
        }
        if (accessor.isServerConnected()) {
            if (!accessor.verifyData(accessor.getServerData())) {
                accessor.getServerData().method_10541().clear();
            }
            List providers = handler.shouldRequestData(accessor);
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (!providers.isEmpty()) {
                    handler.requestData(accessor, providers);
                }
            }
            if (!providers.isEmpty() && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        Theme theme = IWailaConfig.get().overlay().getTheme();
        MutableObject holder = new MutableObject((Object)theme);
        Preconditions.checkNotNull((Object)theme, (Object)"Theme cannot be null");
        Accessor<class_3966> accessor0 = accessor;
        for (JadeBeforeTooltipCollectCallback callback : WailaClientRegistration.instance().beforeTooltipCollectCallback.callbacks()) {
            if (callback.beforeCollecting((MutableObject<Theme>)holder, accessor0)) continue;
            return;
        }
        Preconditions.checkNotNull((Object)((Theme)holder.getValue()), (Object)"Theme cannot be null");
        IThemeHelper themes = IThemeHelper.get();
        if (theme != holder.getValue()) {
            theme = (Theme)holder.getValue();
            themes.setThemeOverride(theme);
        }
        Tooltip tooltip = new Tooltip();
        Element icon = ObjectDataCenter.getIcon();
        tooltip.setIcon(icon);
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            handler.gatherComponents(accessor, $ -> {
                if (Math.abs(WailaCommonRegistration.instance().priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            handler.gatherComponents(accessor, $ -> tooltip);
        }
        tooltip.setIcon(themes.theme().modifyIcon(tooltip.getIcon()));
        BoxElementImpl newElement = new BoxElementImpl(tooltip, themes.theme().tooltipStyle);
        newElement.tag(JadeIds.ROOT);
        for (JadeTooltipCollectedCallback callback : WailaClientRegistration.instance().tooltipCollectedCallback.callbacks()) {
            callback.onTooltipCollected(newElement, accessor);
        }
        if (this.rootElement == null || this.rootElement.layout.method_46426() != newElement.layout.method_46426() || this.rootElement.layout.method_46427() != newElement.layout.method_46427() || this.rootElement.layout.method_25368() != newElement.layout.method_25368() || this.rootElement.layout.method_25364() != newElement.layout.method_25364()) {
            OverlayRenderer.animation.startRect.copy(OverlayRenderer.animation.rect);
            OverlayRenderer.animation.startTime = System.currentTimeMillis();
        }
        this.rootElement = newElement;
        themes.setThemeOverride(null);
    }
}

