/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.core;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.util.ModIdentification;

public abstract class ModNameProvider
implements IToggleableProvider {
    @Override
    public class_2960 getUid() {
        return JadeIds.CORE_MOD_NAME;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public int getDefaultPriority() {
        return 9999;
    }

    public static enum Mode {
        ON,
        OFF,
        SMALLER;

    }

    public static class ForEntity
    extends ModNameProvider
    implements IEntityComponentProvider {
        public static final ForEntity INSTANCE = new ForEntity();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            if (Objects.equal(config.getEnum(JadeIds.CORE_MOD_NAME), (Object)((Object)Mode.OFF))) {
                return;
            }
            tooltip.add(IThemeHelper.get().modName(ModIdentification.getModName(accessor.getEntity())));
        }
    }

    public static class ForBlock
    extends ModNameProvider
    implements IBlockComponentProvider {
        public static final ForBlock INSTANCE = new ForBlock();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            class_1799 pick;
            if (Objects.equal(config.getEnum(JadeIds.CORE_MOD_NAME), (Object)((Object)Mode.OFF))) {
                return;
            }
            String modName = null;
            if (accessor.isFakeBlock()) {
                modName = ModIdentification.getModName(accessor.getFakeBlock());
            }
            if (modName == null && WailaClientRegistration.instance().shouldPick(accessor.getBlockState()) && !(pick = accessor.getPickedResult()).method_7960()) {
                modName = ModIdentification.getModName(pick);
            }
            if (modName == null) {
                modName = ModIdentification.getModName(accessor.getBlock());
            }
            if (!Strings.isNullOrEmpty((String)modName)) {
                tooltip.add(IThemeHelper.get().modName(modName));
            }
        }
    }
}

