/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.common.wrapper;

import fr.rakambda.fallingtree.common.wrapper.IBiome;
import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IChunk;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IRandomSource;
import fr.rakambda.fallingtree.neoforge.common.wrapper.BiomeWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.BlockEntityWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.BlockStateWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ChunkAccessWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.RandomSourceWrapper;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class LevelWrapper
implements ILevel {
    @Generated
    private static final Logger log = LogManager.getLogger(LevelWrapper.class);
    private final @NonNull LevelAccessor raw;

    @Override
    public boolean isServer() {
        return !this.raw.isClientSide();
    }

    @Override
    public @NonNull IChunk getChunk(@NonNull IBlockPos blockPos) {
        BlockPos pos = (BlockPos)blockPos.getRaw();
        return new ChunkAccessWrapper(this.raw.getChunk(pos));
    }

    @Override
    public boolean hasChunk(int x, int z) {
        return this.raw.hasChunk(x, z);
    }

    @Override
    public @NonNull IBlockState getBlockState(@NonNull IBlockPos blockPos) {
        BlockPos pos = (BlockPos)blockPos.getRaw();
        return new BlockStateWrapper(this.raw.getBlockState(pos));
    }

    @Override
    public @Nullable IBlockEntity getBlockEntity(@NonNull IBlockPos blockPos) {
        BlockEntity entity = this.raw.getBlockEntity((BlockPos)blockPos.getRaw());
        return entity == null ? null : new BlockEntityWrapper(entity);
    }

    @Override
    public @NonNull IRandomSource getRandom() {
        return new RandomSourceWrapper(this.raw.getRandom());
    }

    @Override
    public boolean removeBlock(@NonNull IBlockPos blockPos, boolean b) {
        return this.raw.removeBlock((BlockPos)blockPos.getRaw(), b);
    }

    @Override
    public void setBlock(@NonNull IBlockPos blockPos, @NonNull IBlockState blockState) {
        this.raw.setBlock((BlockPos)blockPos.getRaw(), (BlockState)blockState.getRaw(), 1);
    }

    @Override
    public void fallBlock(@NonNull IBlockPos logBlockPos, boolean drop, double dx, double dy, double dz, double vx, double vy, double vz) {
        FallingBlockEntity entity = this.createFallingEntity(logBlockPos, dx, dy, dz);
        if (!drop) {
            entity.disableDrop();
        }
        entity.setDeltaMovement(vx, vy, vz);
        this.raw.addFreshEntity((Entity)entity);
    }

    private @NonNull FallingBlockEntity createFallingEntity(@NonNull IBlockPos logBlockPos, double dx, double dy, double dz) {
        double x = (double)logBlockPos.getX() + dx;
        double y = (double)logBlockPos.getY() + dy;
        double z = (double)logBlockPos.getZ() + dz;
        BlockState blockState = (BlockState)this.getBlockState(logBlockPos).getRaw();
        BlockState newBlockState = blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) : blockState;
        FallingBlockEntity entity = new FallingBlockEntity(EntityType.FALLING_BLOCK, (Level)this.raw);
        entity.blocksBuilding = true;
        entity.setPos(x, y, z);
        entity.xo = x;
        entity.yo = y;
        entity.zo = z;
        entity.blockState = newBlockState;
        return entity;
    }

    @Override
    public @NonNull IBiome getBiome(@NonNull IBlockPos blockPos) {
        return new BiomeWrapper((Holder<Biome>)this.raw.getBiome((BlockPos)blockPos.getRaw()));
    }

    @Generated
    public LevelWrapper(@NonNull LevelAccessor raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    @Generated
    public String toString() {
        return "LevelWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @Generated
    public @NonNull LevelAccessor getRaw() {
        return this.raw;
    }
}

