/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.class_1923;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2261;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2944;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3233;
import net.minecraft.class_3481;
import net.minecraft.class_3746;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5551;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_9009;

public class EndscraperFeature
extends class_3031<class_3111> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.method_8320(pos).method_26204() == class_2246.field_10471;
    protected SimpleBlockPredicate replace = (world, pos) -> class_2944.method_16420((class_3746)world, (class_2338)pos) || world.method_8320(pos).method_26164(class_3481.field_44470) || world.method_8320(pos).method_26204() instanceof class_2261 || world.method_8320(pos).method_26204() == BOPBlocks.NULL_END_STONE || world.method_8320(pos).method_26204() == BOPBlocks.UNMAPPED_END_STONE;

    public EndscraperFeature(Codec<class_3111> deserializer) {
        super(deserializer);
    }

    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        int z;
        int x;
        class_5281 world = featurePlaceContext.method_33652();
        class_2794 chunkGenerator = featurePlaceContext.method_33653();
        class_5819 rand = featurePlaceContext.method_33654();
        class_2338 startPos = featurePlaceContext.method_33655();
        class_3111 config = (class_3111)featurePlaceContext.method_33656();
        while (startPos.method_10264() >= world.method_31607() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.method_10074();
        }
        int size = 9 - 3 * rand.method_43048(2) + 3 * rand.method_43048(4);
        int stories = 1 + rand.method_43048(6);
        int roomHeight = 8;
        int height = stories * roomHeight + 1;
        if (!this.placeOn.matches(world, startPos.method_10069(size / 2, 0, size / 2))) {
            return false;
        }
        if (!this.checkSpace(world, startPos.method_10084(), size, height)) {
            return false;
        }
        class_2338 pos = startPos.method_10084();
        for (x = -1; x <= size + 1; ++x) {
            for (z = -1; z <= size + 1; ++z) {
                int depth = 4 + rand.method_43048(4);
                if ((x == -1 || x == size + 1) && (z == -1 || z == size + 1)) continue;
                for (int y = 0; y <= depth; ++y) {
                    this.setBlock(world, startPos.method_10069(x, -y, z), class_2246.field_10471.method_9564());
                }
            }
        }
        block11: for (int i = 0; i < stories; ++i) {
            int roomType = rand.method_43048(16);
            switch (roomType) {
                default: {
                    this.generateEmptyRoom(world, pos.method_10086(i * roomHeight), size, roomHeight, false);
                    continue block11;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.generateChainRoom(world, pos.method_10086(i * roomHeight), size, roomHeight);
                    continue block11;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.generateDoorRoom(world, pos.method_10086(i * roomHeight), size, roomHeight);
                    continue block11;
                }
                case 12: 
                case 13: {
                    this.generateChorusFruitRoom(world, pos.method_10086(i * roomHeight), size, roomHeight);
                    continue block11;
                }
                case 14: {
                    this.generatePoolRoom(world, pos.method_10086(i * roomHeight), size, roomHeight);
                    continue block11;
                }
                case 15: {
                    this.generateBackroom(world, pos.method_10086(i * roomHeight), size, roomHeight);
                }
            }
        }
        for (x = 0; x <= size; ++x) {
            for (z = 0; z <= size; ++z) {
                if (x == 0 || x == size || z == 0 || z == size) {
                    class_2680 edgeBlock = class_2246.field_27136.method_9564();
                    if (world.method_8409().method_43048(2) == 0) {
                        edgeBlock = class_2246.field_27134.method_9564();
                    }
                    this.setBlock(world, startPos.method_10069(x, height, z), edgeBlock);
                } else {
                    this.setBlock(world, startPos.method_10069(x, height, z), class_2246.field_27168.method_9564());
                }
                if (x == 0 && z == 0) {
                    this.setBlock(world, startPos.method_10069(x, height + 1, z), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (x == 0 && z == size) {
                    this.setBlock(world, startPos.method_10069(x, height + 1, z), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (x == size && z == 0) {
                    this.setBlock(world, startPos.method_10069(x, height + 1, z), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (x == size && z == size) {
                    this.setBlock(world, startPos.method_10069(x, height + 1, z), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                if (x == 0 || x == size) {
                    this.setBlock(world, startPos.method_10069(x, height + 1, z), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2389.field_10905, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10904, (Comparable)Boolean.valueOf(true)));
                }
                if (z != 0 && z != size) continue;
                this.setBlock(world, startPos.method_10069(x, height + 1, z), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2389.field_10907, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2389.field_10903, (Comparable)Boolean.valueOf(true)));
            }
        }
        return true;
    }

    public void generateEmptyRoom(class_5281 world, class_2338 pos, int size, int roomHeight, boolean windowsOpen) {
        int z;
        int x;
        for (x = 0; x <= size; ++x) {
            for (z = 0; z <= size; ++z) {
                class_2680 separatorBlock = class_2246.field_27136.method_9564();
                if (world.method_8409().method_43048(2) == 0) {
                    separatorBlock = class_2246.field_27134.method_9564();
                }
                this.setBlock(world, pos.method_10069(x, 0, z), separatorBlock);
            }
        }
        pos = pos.method_10084();
        for (x = 0; x <= size; ++x) {
            for (z = 0; z <= size; ++z) {
                for (int y = 0; y <= roomHeight - 2; ++y) {
                    class_2680 wallBlock = class_2246.field_10124.method_9564();
                    if (x == 0) {
                        wallBlock = z % 3 == 1 || z % 3 == 2 ? (y % 3 == 1 ? (class_2680)((class_2680)((class_2680)class_2246.field_47063.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11039)).method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12617)).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(!windowsOpen)) : (y % 3 == 2 ? (class_2680)((class_2680)((class_2680)class_2246.field_47063.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11039)).method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12619)).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(!windowsOpen)) : (world.method_8409().method_43048(5) == 0 ? class_2246.field_10471.method_9564() : class_2246.field_10462.method_9564()))) : (world.method_8409().method_43048(5) == 0 ? class_2246.field_10471.method_9564() : class_2246.field_10462.method_9564());
                    }
                    if (x == size) {
                        wallBlock = z % 3 == 1 || z % 3 == 2 ? (y % 3 == 1 ? (class_2680)((class_2680)((class_2680)class_2246.field_47063.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11034)).method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12617)).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(!windowsOpen)) : (y % 3 == 2 ? (class_2680)((class_2680)((class_2680)class_2246.field_47063.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11034)).method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12619)).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(!windowsOpen)) : (world.method_8409().method_43048(5) == 0 ? class_2246.field_10471.method_9564() : class_2246.field_10462.method_9564()))) : (world.method_8409().method_43048(5) == 0 ? class_2246.field_10471.method_9564() : class_2246.field_10462.method_9564());
                    }
                    if (z == 0) {
                        wallBlock = x % 3 == 1 || x % 3 == 2 ? (y % 3 == 1 ? (class_2680)((class_2680)((class_2680)class_2246.field_47063.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12617)).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(!windowsOpen)) : (y % 3 == 2 ? (class_2680)((class_2680)((class_2680)class_2246.field_47063.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12619)).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(!windowsOpen)) : (world.method_8409().method_43048(5) == 0 ? class_2246.field_10471.method_9564() : class_2246.field_10462.method_9564()))) : (world.method_8409().method_43048(5) == 0 ? class_2246.field_10471.method_9564() : class_2246.field_10462.method_9564());
                    }
                    if (z == size) {
                        wallBlock = x % 3 == 1 || x % 3 == 2 ? (y % 3 == 1 ? (class_2680)((class_2680)((class_2680)class_2246.field_47063.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11035)).method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12617)).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(!windowsOpen)) : (y % 3 == 2 ? (class_2680)((class_2680)((class_2680)class_2246.field_47063.method_9564().method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11035)).method_11657((class_2769)class_2533.field_11625, (Comparable)class_2760.field_12619)).method_11657((class_2769)class_2533.field_11631, (Comparable)Boolean.valueOf(!windowsOpen)) : (world.method_8409().method_43048(5) == 0 ? class_2246.field_10471.method_9564() : class_2246.field_10462.method_9564()))) : (world.method_8409().method_43048(5) == 0 ? class_2246.field_10471.method_9564() : class_2246.field_10462.method_9564());
                    }
                    if (wallBlock.method_26215()) continue;
                    this.setBlock(world, pos.method_10069(x, y, z), wallBlock);
                }
            }
        }
    }

    public void generateChainRoom(class_5281 world, class_2338 pos, int size, int roomHeight) {
        this.generateEmptyRoom(world, pos, size, roomHeight, false);
        for (int x = 1; x <= size - 1; ++x) {
            for (int z = 1; z <= size - 1; ++z) {
                if (world.method_8409().method_43048(4) != 0) continue;
                int chainHeight = world.method_8409().method_43048(roomHeight);
                for (int y = 0; y < chainHeight; ++y) {
                    this.setBlock(world, pos.method_10069(x, roomHeight - 1 - y, z), class_2246.field_23985.method_9564());
                }
            }
        }
    }

    public void generateDoorRoom(class_5281 world, class_2338 pos, int size, int roomHeight) {
        this.generateEmptyRoom(world, pos, size, roomHeight, false);
        for (int x = 1; x <= size - 1; ++x) {
            for (int z = 1; z <= size - 1; ++z) {
                if (!(x % 3 != 1 && x % 3 != 2 || z % 3 != 1 && z % 3 != 2)) {
                    this.setBlock(world, pos.method_10069(x, roomHeight - 1, z), class_2246.field_47059.method_9564());
                }
                if (x % 3 != 0 || z % 3 != 0) continue;
                class_2350 direction = class_2350.class_2353.field_11062.method_10183(world.method_8409());
                class_2750 hingeSide = class_2750.field_12588;
                boolean open = false;
                if (world.method_8409().method_43048(2) == 0) {
                    hingeSide = class_2750.field_12586;
                }
                if (world.method_8409().method_43048(2) == 0) {
                    open = true;
                }
                this.setBlock(world, pos.method_10069(x, 1, z), (class_2680)((class_2680)((class_2680)((class_2680)class_2246.field_47047.method_9564().method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12607)).method_11657((class_2769)class_2323.field_10938, (Comparable)direction)).method_11657((class_2769)class_2323.field_10941, (Comparable)hingeSide)).method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(open)));
                this.setBlock(world, pos.method_10069(x, 2, z), (class_2680)((class_2680)((class_2680)((class_2680)class_2246.field_47047.method_9564().method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609)).method_11657((class_2769)class_2323.field_10938, (Comparable)direction)).method_11657((class_2769)class_2323.field_10941, (Comparable)hingeSide)).method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(open)));
            }
        }
    }

    public void generateChorusFruitRoom(class_5281 world, class_2338 pos, int size, int roomHeight) {
        this.generateEmptyRoom(world, pos, size, roomHeight, false);
        for (int x = 1; x <= size - 1; ++x) {
            for (int z = 1; z <= size - 1; ++z) {
                class_2680 floorBlock = class_2246.field_10462.method_9564();
                if (world.method_8409().method_43048(3) == 0) {
                    floorBlock = class_2246.field_10471.method_9564();
                }
                if (x == 1 || x == size - 1 || z == 1 || z == size - 1) {
                    this.setBlock(world, pos.method_10069(x, 1, z), floorBlock);
                    continue;
                }
                if (x % 3 == 0 && z % 3 == 0) {
                    this.setBlock(world, pos.method_10069(x, 1, z), class_2246.field_10471.method_9564());
                    this.setBlock(world, pos.method_10069(x, 2, z), class_2246.field_10528.method_9564());
                    continue;
                }
                if (x % 3 == 0 || z % 3 == 0) {
                    this.setBlock(world, pos.method_10069(x, 1, z), floorBlock);
                    continue;
                }
                this.setBlock(world, pos.method_10069(x, 1, z), class_2246.field_10505.method_9564());
            }
        }
    }

    public void generatePoolRoom(class_5281 world, class_2338 pos, int size, int roomHeight) {
        this.generateEmptyRoom(world, pos, size, roomHeight, true);
        for (int x = 1; x <= size - 1; ++x) {
            for (int z = 1; z <= size - 1; ++z) {
                if (x == 1 || x == size - 1 || z == 1 || z == size - 1) {
                    this.setBlock(world, pos.method_10069(x, 1, z), (class_2680)class_2246.field_47070.method_9564().method_11657((class_2769)class_9009.field_47523, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                this.setBlock(world, pos.method_10069(x, 1, z), class_2246.field_10382.method_9564());
            }
        }
    }

    public void generateBackroom(class_5281 world, class_2338 pos, int size, int roomHeight) {
        int z;
        int x;
        this.generateEmptyRoom(world, pos, size, roomHeight, false);
        for (x = 1; x <= size - 1; ++x) {
            for (z = 1; z <= size - 1; ++z) {
                for (int y = 1; y <= roomHeight - 1; ++y) {
                    if (x != 1 && x != size - 1 && z != 1 && z != size - 1) continue;
                    this.setBlock(world, pos.method_10069(x, y, z), class_2246.field_10471.method_9564());
                }
            }
        }
        for (x = 2; x <= size - 2; ++x) {
            for (z = 2; z <= size - 2; ++z) {
                this.setBlock(world, pos.method_10069(x, 1, z), BOPBlocks.ALGAL_END_STONE.method_9564());
            }
        }
        for (x = 2; x <= size - 2; ++x) {
            for (z = 2; z <= size - 2; ++z) {
                if (z % 3 == 0 && x != 2 && x != size - 2) {
                    if (x % 3 == 1) {
                        this.setBlock(world, pos.method_10069(x, roomHeight - 1, z), (class_2680)class_2246.field_10455.method_9564().method_11657((class_2769)class_5551.field_10927, (Comparable)class_2350.field_11034));
                        this.setBlock(world, pos.method_10069(x, roomHeight - 2, z), BOPBlocks.WISPJELLY.method_9564());
                        continue;
                    }
                    if (x % 3 == 2) {
                        this.setBlock(world, pos.method_10069(x, roomHeight - 1, z), (class_2680)class_2246.field_10455.method_9564().method_11657((class_2769)class_5551.field_10927, (Comparable)class_2350.field_11039));
                        this.setBlock(world, pos.method_10069(x, roomHeight - 2, z), BOPBlocks.WISPJELLY.method_9564());
                        continue;
                    }
                    this.setBlock(world, pos.method_10069(x, roomHeight - 1, z), class_2246.field_10471.method_9564());
                    this.setBlock(world, pos.method_10069(x, roomHeight - 2, z), class_2246.field_10471.method_9564());
                    continue;
                }
                this.setBlock(world, pos.method_10069(x, roomHeight - 1, z), class_2246.field_10471.method_9564());
                this.setBlock(world, pos.method_10069(x, roomHeight - 2, z), class_2246.field_10471.method_9564());
            }
        }
        int wallLength = size / 3 - 1;
        int wallDistance = size / 3 - 2;
        for (int x2 = 0; x2 < wallLength; ++x2) {
            int y;
            for (y = 1; y <= roomHeight - 3; ++y) {
                this.setBlock(world, pos.method_10069(2 + x2, y, 2 + wallDistance), BOPBlocks.UNMAPPED_END_STONE.method_9564());
                this.setBlock(world, pos.method_10069(size - 2 - x2, y, 2 + wallDistance), BOPBlocks.UNMAPPED_END_STONE.method_9564());
            }
            for (y = 1; y <= roomHeight - 4; ++y) {
                this.setBlock(world, pos.method_10069(2 + x2, y, size - 2 - wallDistance), BOPBlocks.UNMAPPED_END_STONE.method_9564());
                this.setBlock(world, pos.method_10069(size - 2 - x2, y, size - 2 - wallDistance), BOPBlocks.UNMAPPED_END_STONE.method_9564());
            }
        }
    }

    public boolean setBlock(class_5281 world, class_2338 pos, class_2680 state) {
        if (this.replace.matches(world, pos)) {
            super.method_13153((class_1945)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(class_5281 world, class_2338 pos, int size, int height) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -1; x <= size + 1; ++x) {
                for (int z = -1; z <= size + 1; ++z) {
                    class_2338 pos1 = pos.method_10069(x, y, z);
                    if (pos1.method_10264() < 255 && this.replace.matches(world, pos1) && this.respectsCutoff((class_3233)world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean respectsCutoff(class_3233 region, class_2338 pos) {
        int i = class_4076.method_18675((int)pos.method_10263());
        int j = class_4076.method_18675((int)pos.method_10260());
        class_1923 chunkpos = region.method_33561();
        int k = Math.abs(chunkpos.field_9181 - i);
        int l = Math.abs(chunkpos.field_9180 - j);
        return k <= region.field_51876.comp_2806() && l <= region.field_51876.comp_2806();
    }
}

