/*
 * Decompiled with CFR 0.152.
 */
package terrablender.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_3754;
import net.minecraft.class_4766;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import terrablender.DimensionTypeTags;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;
import terrablender.core.TerraBlender;
import terrablender.worldgen.IExtendedBiomeSource;
import terrablender.worldgen.IExtendedNoiseGeneratorSettings;
import terrablender.worldgen.IExtendedParameterList;
import terrablender.worldgen.IExtendedTheEndBiomeSource;

public class LevelUtils {
    public static void initializeOnServerStart(MinecraftServer server) {
        class_5455.class_6890 registryAccess = server.method_30611();
        class_2378 levelStemRegistry = registryAccess.method_30530(class_7924.field_41224);
        long seed = server.method_27728().method_28057().method_28028();
        for (Map.Entry entry : levelStemRegistry.method_29722()) {
            class_5363 stem = (class_5363)entry.getValue();
            LevelUtils.initializeBiomes((class_5455)registryAccess, (class_6880<class_2874>)stem.comp_1012(), (class_5321<class_5363>)((class_5321)entry.getKey()), stem.comp_1013(), seed);
        }
    }

    public static boolean shouldApplyToChunkGenerator(class_2794 chunkGenerator) {
        return chunkGenerator instanceof class_3754 && LevelUtils.shouldApplyToBiomeSource(chunkGenerator.method_12098());
    }

    public static boolean shouldApplyToBiomeSource(class_1966 biomeSource) {
        return biomeSource instanceof class_4766;
    }

    public static RegionType getRegionTypeForDimension(class_6880<class_2874> dimensionType) {
        if (dimensionType.method_40220(DimensionTypeTags.NETHER_REGIONS)) {
            return RegionType.NETHER;
        }
        if (dimensionType.method_40220(DimensionTypeTags.OVERWORLD_REGIONS)) {
            return RegionType.OVERWORLD;
        }
        return null;
    }

    public static void initializeBiomes(class_5455 registryAccess, class_6880<class_2874> dimensionType, class_5321<class_5363> levelResourceKey, class_2794 chunkGenerator, long seed) {
        if (!(chunkGenerator instanceof class_3754)) {
            return;
        }
        class_3754 noiseBasedChunkGenerator = (class_3754)chunkGenerator;
        class_5284 generatorSettings = (class_5284)noiseBasedChunkGenerator.method_41541().comp_349();
        if (chunkGenerator.method_12098() instanceof class_2169) {
            ((IExtendedTheEndBiomeSource)chunkGenerator.method_12098()).initializeForTerraBlender(registryAccess, seed);
            ((IExtendedNoiseGeneratorSettings)generatorSettings).setRuleCategory(SurfaceRuleManager.RuleCategory.END);
            return;
        }
        if (!LevelUtils.shouldApplyToBiomeSource(chunkGenerator.method_12098())) {
            return;
        }
        RegionType regionType = LevelUtils.getRegionTypeForDimension(dimensionType);
        class_4766 biomeSource = (class_4766)chunkGenerator.method_12098();
        IExtendedBiomeSource biomeSourceEx = (IExtendedBiomeSource)biomeSource;
        if (regionType == null) {
            return;
        }
        SurfaceRuleManager.RuleCategory ruleCategory = switch (regionType) {
            case RegionType.OVERWORLD -> SurfaceRuleManager.RuleCategory.OVERWORLD;
            case RegionType.NETHER -> SurfaceRuleManager.RuleCategory.NETHER;
            default -> throw new IllegalArgumentException("Attempted to get surface rule category for unsupported region type " + String.valueOf((Object)regionType));
        };
        ((IExtendedNoiseGeneratorSettings)generatorSettings).setRuleCategory(ruleCategory);
        class_6544.class_6547 parameters = biomeSource.method_49506();
        IExtendedParameterList parametersEx = (IExtendedParameterList)parameters;
        parametersEx.initializeForTerraBlender(registryAccess, regionType, seed);
        class_2378 biomeRegistry = registryAccess.method_30530(class_7924.field_41236);
        ImmutableList.Builder builder = ImmutableList.builder();
        Regions.get(regionType).forEach(region -> region.addBiomes((class_2378<class_1959>)biomeRegistry, pair -> {
            if (biomeRegistry.method_35842((class_5321)pair.getSecond())) {
                builder.add((Object)biomeRegistry.method_46747((class_5321)pair.getSecond()));
            }
        }));
        biomeSourceEx.appendDeferredBiomesList((List<class_6880<class_1959>>)builder.build());
        TerraBlender.LOGGER.info(String.format("Initialized TerraBlender biomes for level stem %s", levelResourceKey.method_29177()));
    }
}

