/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_10539;
import net.minecraft.class_1061;
import net.minecraft.class_1079;
import net.minecraft.class_1080;
import net.minecraft.class_1084;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7771;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;

public class GeckoLibAnimatedTexture
extends class_1049
implements class_1061 {
    protected AnimationInfo animatedTexture;
    protected int frameWidth;
    protected int frameHeight;
    protected class_1011 baseImage;

    public GeckoLibAnimatedTexture(class_2960 location) {
        super(location);
    }

    public boolean isAnimated() {
        return this.animatedTexture != null;
    }

    public class_10539 method_65809(class_3300 resourceManager) throws IOException {
        class_3298 resource = resourceManager.getResourceOrThrow(this.method_65859());
        try (InputStream stream = resource.method_14482();){
            this.baseImage = class_1011.method_4309((InputStream)stream);
        }
        if (this.baseImage != null) {
            this.animatedTexture = resource.method_14481().method_43041(class_1079.field_55537).map(this::buildAnimatedTexture).orElse(null);
        }
        return new class_10539(this.baseImage, (class_1084)resource.method_14481().method_43041(class_1084.field_55542).orElse(null));
    }

    public void method_65857(class_10539 textureContents) {
        boolean clamp = textureContents.method_65873();
        boolean blur = textureContents.method_65872();
        this.method_65856(this.baseImage, blur, clamp);
    }

    public void method_65856(class_1011 image, boolean blur, boolean clamp) {
        class_2960 textureId = this.method_65859();
        Objects.requireNonNull(textureId);
        this.field_56974 = RenderSystem.getDevice().createTexture(textureId.toString(), 5, TextureFormat.RGBA8, this.frameWidth, this.frameHeight, 1, 1);
        this.field_56974.setTextureFilter(FilterMode.NEAREST, false);
        this.field_60597 = RenderSystem.getDevice().createTextureView(this.field_56974);
        this.method_4527(blur, false);
        this.method_65924(clamp);
        this.uploadFrame(image, 0, 0, this.field_56974);
    }

    @Nullable
    protected AnimationInfo buildAnimatedTexture(class_1079 animMeta) {
        class_7771 frameSize = animMeta.method_24143(this.baseImage.method_4307(), this.baseImage.method_4323());
        this.frameWidth = frameSize.comp_1049();
        this.frameHeight = frameSize.comp_1050();
        int frameColumns = this.baseImage.method_4307() / this.frameWidth;
        int frameRows = this.baseImage.method_4323() / this.frameHeight;
        int frames = frameColumns * frameRows;
        int defaultFrameTime = animMeta.comp_3456();
        int frameCount = animMeta.comp_3453().map(List::size).orElse(frames);
        if (frameCount <= 1) {
            return null;
        }
        ObjectArrayList frameList = new ObjectArrayList(frameCount);
        if (animMeta.comp_3453().isEmpty()) {
            for (int i = 0; i < frames; ++i) {
                frameList.add(new FrameInfo(i, defaultFrameTime));
            }
        } else {
            for (class_1080 frame : (List)animMeta.comp_3453().get()) {
                frameList.add(new FrameInfo(frame.comp_3451(), frame.method_4691(defaultFrameTime)));
            }
            int frameIndex = 0;
            IntOpenHashSet validFrames = new IntOpenHashSet();
            Iterator iterator = frameList.iterator();
            while (iterator.hasNext()) {
                FrameInfo frameInfo = (FrameInfo)iterator.next();
                boolean validFrame = true;
                if (frameInfo.time <= 0) {
                    GeckoLibConstants.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)this.method_65859(), (Object)frameIndex, (Object)frameInfo.time);
                    validFrame = false;
                }
                if (frameInfo.index < 0 || frameInfo.index >= frames) {
                    GeckoLibConstants.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)this.method_65859(), (Object)frameIndex, (Object)frameInfo.index);
                    validFrame = false;
                }
                if (validFrame) {
                    validFrames.add(frameInfo.index);
                } else {
                    iterator.remove();
                }
                ++frameIndex;
            }
            int[] unusedFrames = IntStream.range(0, frames).filter(arg_0 -> GeckoLibAnimatedTexture.lambda$buildAnimatedTexture$0((IntSet)validFrames, arg_0)).toArray();
            if (unusedFrames.length > 0) {
                GeckoLibConstants.LOGGER.warn("Unused frames in sprite {}: {}", (Object)this.method_65859(), (Object)Arrays.toString(unusedFrames));
            }
        }
        return new AnimationInfo(List.copyOf(frameList), frameColumns, animMeta.comp_3457());
    }

    protected void uploadFrame(class_1011 image, int x, int y, GpuTexture gpuTexture) {
        RenderSystem.getDevice().createCommandEncoder().writeToTexture(gpuTexture, image, 0, 0, x, y, this.frameWidth, this.frameHeight, 0, 0);
    }

    public void method_4622() {
        this.animatedTexture.tick();
    }

    public void close() {
        if (this.baseImage != null) {
            this.baseImage.close();
        }
        if (this.animatedTexture != null) {
            this.animatedTexture.close();
        }
        super.close();
    }

    private static /* synthetic */ boolean lambda$buildAnimatedTexture$0(IntSet validFrames, int frame) {
        return !validFrames.contains(frame);
    }

    protected class AnimationInfo
    implements AutoCloseable {
        protected final List<FrameInfo> frames;
        protected final int frameRowSize;
        protected final boolean interpolateFrames;
        @Nullable
        protected final InterpolationData interpolationData;
        protected final class_1011 currentFrameBuffer;
        int currentFrame;
        int subFrame;

        public AnimationInfo(List<FrameInfo> frames, int frameRowSize, boolean interpolateFrames) {
            this.frames = frames;
            this.frameRowSize = frameRowSize;
            this.interpolateFrames = interpolateFrames;
            this.interpolationData = this.interpolateFrames ? new InterpolationData(GeckoLibAnimatedTexture.this.frameWidth, GeckoLibAnimatedTexture.this.frameHeight) : null;
            this.currentFrameBuffer = new class_1011(GeckoLibAnimatedTexture.this.frameWidth, GeckoLibAnimatedTexture.this.frameHeight, false);
        }

        int getFrameColumn(int frameIndex) {
            return frameIndex % this.frameRowSize;
        }

        int getFrameRow(int frameIndex) {
            return frameIndex / this.frameRowSize;
        }

        public void tick() {
            ++this.subFrame;
            FrameInfo prevFrameInfo = this.frames.get(this.currentFrame);
            if (this.subFrame >= prevFrameInfo.time) {
                this.currentFrame = (this.currentFrame + 1) % this.frames.size();
                this.subFrame = 0;
                int frameIndex = this.frames.get((int)this.currentFrame).index;
                if (prevFrameInfo.index != frameIndex) {
                    GeckoLibAnimatedTexture instance = GeckoLibAnimatedTexture.this;
                    int frameX = this.getFrameColumn(frameIndex) * instance.frameWidth;
                    int frameY = this.getFrameRow(frameIndex) * instance.frameHeight;
                    instance.baseImage.method_47594(this.currentFrameBuffer, frameX, frameY, 0, 0, instance.frameWidth, instance.frameHeight, false, false);
                    GeckoLibAnimatedTexture.this.uploadFrame(this.currentFrameBuffer, 0, 0, GeckoLibAnimatedTexture.this.method_68004());
                }
            } else if (this.interpolationData != null) {
                this.interpolationData.tickAndUpload(GeckoLibAnimatedTexture.this.method_68004());
            }
        }

        @Override
        public void close() {
            if (this.interpolationData != null) {
                this.interpolationData.close();
            }
        }

        protected class InterpolationData
        implements AutoCloseable {
            protected final class_1011 buffer;

            public InterpolationData(int frameWidth, int frameHeight) {
                this.buffer = new class_1011(frameWidth, frameHeight, false);
            }

            protected void tickAndUpload(GpuTexture gpuTexture) {
                AnimationInfo instance = AnimationInfo.this;
                List<FrameInfo> frames = instance.frames;
                FrameInfo currentFrameInfo = frames.get(instance.currentFrame);
                int nextFrameIndex = frames.get((int)((instance.currentFrame + 1) % frames.size())).index;
                if (currentFrameInfo.index != nextFrameIndex) {
                    float partialFrame = (float)instance.subFrame / (float)currentFrameInfo.time;
                    for (int pixelY = 0; pixelY < GeckoLibAnimatedTexture.this.frameHeight; ++pixelY) {
                        for (int pixelX = 0; pixelX < GeckoLibAnimatedTexture.this.frameWidth; ++pixelX) {
                            int framePixel = this.getPixel(instance, currentFrameInfo.index, pixelX, pixelY);
                            int nextFramePixel = this.getPixel(instance, nextFrameIndex, pixelX, pixelY);
                            this.buffer.method_61941(pixelX, pixelY, class_9848.method_61319((float)partialFrame, (int)framePixel, (int)nextFramePixel));
                        }
                    }
                    GeckoLibAnimatedTexture.this.uploadFrame(this.buffer, 0, 0, gpuTexture);
                }
            }

            protected int getPixel(AnimationInfo animationInfo, int frameIndex, int x, int y) {
                GeckoLibAnimatedTexture texture = GeckoLibAnimatedTexture.this;
                return texture.baseImage.method_61940(x + animationInfo.getFrameColumn(frameIndex) * texture.frameWidth, y + animationInfo.getFrameRow(frameIndex) * texture.frameHeight);
            }

            @Override
            public void close() {
                this.buffer.close();
            }
        }
    }

    protected record FrameInfo(int index, int time) {
    }
}

