/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10442;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.class_970;
import net.minecraft.class_9848;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public class GeoEntityRenderer<T extends class_1297, R extends class_10017>
extends class_897<T, R>
implements GeoRenderer<T, Void, R> {
    protected final GeoRenderLayersContainer<T, Void, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected final class_10442 itemModelResolver;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoEntityRenderer(class_5617.class_5618 context, GeoModel<T> model) {
        super(context);
        this.model = model;
        this.itemModelResolver = context.method_65566();
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, Void, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoEntityRenderer<T, R> addRenderLayer(GeoRenderLayer<T, Void, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoEntityRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoEntityRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, Void relatedObject) {
        return animatable.method_5628();
    }

    @Override
    public int getRenderColor(T animatable, Void relatedObject, float partialTick) {
        int color = GeoRenderer.super.getRenderColor(animatable, relatedObject, partialTick);
        if (animatable.method_5767() && !animatable.method_5756(ClientUtil.getClientPlayer())) {
            color = class_9848.method_61330((int)class_3532.method_15386((float)((float)(class_9848.method_61320((int)color) * 38) / 255.0f)), (int)color);
        }
        return color;
    }

    @Override
    public int getPackedOverlay(T animatable, Void relatedObject, float u, float partialTick) {
        if (!(animatable instanceof class_1309)) {
            return class_4608.field_21444;
        }
        class_1309 entity = (class_1309)animatable;
        return class_4608.method_23625((int)class_4608.method_23210((float)u), (int)class_4608.method_23212((entity.field_6235 > 0 || entity.field_6213 > 0 ? 1 : 0) != 0));
    }

    public double getNameRenderCutoffDistance(T animatable) {
        return 32.0;
    }

    public boolean method_3921(T animatable, double distToCameraSq) {
        double nameRenderCutoff;
        if (!(animatable instanceof class_1309)) {
            return super.method_3921(animatable, distToCameraSq);
        }
        if (animatable.method_21751() && distToCameraSq >= (nameRenderCutoff = this.getNameRenderCutoffDistance(animatable)) * nameRenderCutoff) {
            return false;
        }
        if (!(!(animatable instanceof class_1308) || animatable.method_5733() || animatable.method_16914() && animatable == this.field_4676.field_4678)) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        boolean visibleToClient = !animatable.method_5756(ClientUtil.getClientPlayer());
        class_268 entityTeam = animatable.method_5781();
        if (entityTeam == null) {
            return class_310.method_1498() && animatable != minecraft.method_1560() && visibleToClient && !animatable.method_5782();
        }
        class_268 playerTeam = ClientUtil.getClientPlayer().method_5781();
        return switch (entityTeam.method_1201()) {
            default -> throw new MatchException(null, null);
            case class_270.class_272.field_1442 -> visibleToClient;
            case class_270.class_272.field_1443 -> false;
            case class_270.class_272.field_1444 -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.method_1206((class_270)playerTeam) && (entityTeam.method_1199() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case class_270.class_272.field_1446 -> playerTeam == null ? visibleToClient : !entityTeam.method_1206((class_270)playerTeam) && visibleToClient;
        };
    }

    protected float calculateYRot(T animatable, float yHeadRot, float partialTick) {
        class_1297 class_12972 = animatable.method_5854();
        if (!(class_12972 instanceof class_1309)) {
            return animatable.method_43078();
        }
        class_1309 vehicle = (class_1309)class_12972;
        float vehicleRotation = class_3532.method_17821((float)partialTick, (float)vehicle.field_6220, (float)vehicle.field_6283);
        float clampedVehicleRotation = class_3532.method_15363((float)class_3532.method_15393((float)(-vehicleRotation)), (float)-85.0f, (float)85.0f);
        vehicleRotation = yHeadRot - vehicleRotation;
        if (Math.abs(clampedVehicleRotation) > 50.0f) {
            vehicleRotation += clampedVehicleRotation * 0.2f;
        }
        return vehicleRotation;
    }

    @Override
    @Nullable
    public class_1921 getRenderType(R renderState, class_2960 texture) {
        if (((class_10017)renderState).field_53333 && !((GeoRenderState)renderState).getGeckolibData(DataTickets.INVISIBLE_TO_PLAYER).booleanValue()) {
            return class_1921.method_29379((class_2960)texture);
        }
        if (!((class_10017)renderState).field_53333) {
            return GeoRenderer.super.getRenderType(renderState, texture);
        }
        return ((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_GLOWING) != false ? class_1921.method_23287((class_2960)texture) : null;
    }

    @Override
    @ApiStatus.Internal
    public R captureDefaultRenderState(T animatable, Void relatedObject, R renderState, float partialTick) {
        double d;
        class_1309 livingEntity;
        class_10042 state;
        GeoRenderer.super.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        class_10042 livingRenderState = renderState instanceof class_10042 ? (state = (class_10042)renderState) : null;
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, livingRenderState != null ? livingRenderState.field_53461 : animatable.method_5767() && animatable.method_5756(ClientUtil.getClientPlayer()));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_GLOWING, livingRenderState != null ? livingRenderState.field_53462 : class_310.method_1551().method_27022(animatable));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_SHAKING, livingRenderState != null ? livingRenderState.field_53456 : animatable.method_32314());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.ENTITY_POSE, livingRenderState != null ? livingRenderState.field_53465 : animatable.method_18376());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.ENTITY_PITCH, Float.valueOf(livingRenderState != null ? livingRenderState.field_53448 : animatable.method_61414(partialTick)));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.ENTITY_YAW, Float.valueOf(livingRenderState != null ? livingRenderState.field_53447 : this.calculateYRot(animatable, 0.0f, partialTick)));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.ENTITY_BODY_YAW, livingRenderState != null ? Float.valueOf(livingRenderState.field_53446) : ((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_YAW));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.VELOCITY, animatable.method_18798());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCKPOS, animatable.method_24515());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.POSITION, livingRenderState != null ? new class_243(livingRenderState.field_53325, livingRenderState.field_53326, livingRenderState.field_53327) : animatable.method_30950(1.0f));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.SPRINTING, animatable.method_5624());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_CROUCHING, animatable.method_18276());
        GeoRenderState geoRenderState = (GeoRenderState)renderState;
        if (animatable instanceof class_1309) {
            livingEntity = (class_1309)animatable;
            d = livingEntity.field_42108.method_48566();
        } else {
            d = animatable.method_18798().method_1027();
        }
        geoRenderState.addGeckolibData(DataTickets.IS_MOVING, d >= (double)this.getMotionAnimThreshold((GeoAnimatable)animatable));
        if (animatable instanceof class_1309) {
            livingEntity = (class_1309)animatable;
            ((GeoRenderState)renderState).addGeckolibData(DataTickets.SWINGING_ARM, livingEntity.field_6252);
            ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_DEAD_OR_DYING, livingEntity.method_29504());
        }
        return renderState;
    }

    @Override
    public void preRender(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        }
    }

    @Override
    public void adjustPositionForRender(R renderState, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
        class_2350 bedDirection;
        class_10042 state;
        class_10042 livingRenderState;
        if (isReRender) {
            return;
        }
        class_10042 class_100422 = livingRenderState = renderState instanceof class_10042 ? (state = (class_10042)renderState) : null;
        if (((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_POSE) == class_4050.field_18078 && livingRenderState != null && (bedDirection = livingRenderState.field_53463) != null) {
            float eyePosOffset = livingRenderState.field_53331 - 0.1f;
            poseStack.method_46416((float)(-bedDirection.method_10148()) * eyePosOffset, 0.0f, (float)(-bedDirection.method_10165()) * eyePosOffset);
        }
    }

    @Override
    public void scaleModelForRender(R renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
        float f;
        if (renderState instanceof class_10042) {
            class_10042 livingRenderState = (class_10042)renderState;
            f = livingRenderState.field_53453;
        } else {
            f = 1.0f;
        }
        float nativeScale = f;
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth * nativeScale, heightScale * this.scaleHeight * nativeScale, poseStack, model, isReRender);
    }

    @ApiStatus.Internal
    public void method_3936(R renderState, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        this.defaultRender((GeoRenderState)renderState, poseStack, bufferSource, null, null);
    }

    @Override
    public void actuallyRender(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            float f;
            if (renderState instanceof class_10042) {
                class_10042 state = (class_10042)renderState;
                f = state.field_53453;
            } else {
                f = 1.0f;
            }
            this.applyRotations(renderState, poseStack, f);
            this.getGeoModel().handleAnimations(this.createAnimationState((GeoRenderState)renderState));
            poseStack.method_46416(0.0f, 0.01f, 0.0f);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        }
    }

    @Override
    public void renderFinal(R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        super.method_3936(renderState, poseStack, bufferSource, packedLight);
    }

    @Override
    public void doPostRenderCleanup() {
        this.entityRenderTranslations = null;
        this.modelRenderTranslations = null;
    }

    @Override
    public void renderRecursively(R renderState, class_4587 poseStack, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        Pair boneRenderTask;
        poseStack.method_22903();
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.translateMatrix(localMatrix, this.method_23169((class_10017)renderState).method_46409()));
            bone.setWorldSpaceMatrix(RenderUtil.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), new Vector3f((float)((class_10017)renderState).field_53325, (float)((class_10017)renderState).field_53326, (float)((class_10017)renderState).field_53327)));
        }
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
        if (!isReRender && (boneRenderTask = (Pair)this.getPerBoneTasks((GeoRenderState)renderState).get((Object)bone)) != null) {
            ((MutableObject)boneRenderTask.left()).setValue((Object)poseStack.method_23760().method_56822());
        }
        this.renderCubesOfBone((GeoRenderState)renderState, bone, poseStack, buffer, packedLight, packedOverlay, renderColor);
        this.renderChildBones((GeoRenderState)renderState, bone, poseStack, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        poseStack.method_22909();
    }

    protected void applyRotations(R renderState, class_4587 poseStack, float nativeScale) {
        boolean sleeping;
        float rotationYaw = ((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_BODY_YAW).floatValue();
        if (((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_SHAKING).booleanValue()) {
            rotationYaw += (float)(Math.cos((double)((class_10017)renderState).field_53328 * 3.25) * Math.PI * 0.4);
        }
        boolean bl = sleeping = ((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_POSE) == class_4050.field_18078;
        if (!sleeping) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - rotationYaw));
        }
        if (renderState instanceof class_10042) {
            class_10042 livingRenderState = (class_10042)renderState;
            if (livingRenderState.field_53449 > 0.0f) {
                poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(Math.min(class_3532.method_15355((float)((livingRenderState.field_53449 - 1.0f) / 20.0f * 1.6f)), 1.0f) * this.getDeathMaxRotation((GeoRenderState)renderState)));
            } else if (livingRenderState.field_53459) {
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f - livingRenderState.field_53448));
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(((class_10017)renderState).field_53328 * -75.0f));
            } else if (sleeping) {
                class_2350 bedOrientation = livingRenderState.field_53463;
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(bedOrientation != null ? RenderUtil.getDirectionAngle(bedOrientation) : rotationYaw));
                poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(this.getDeathMaxRotation((GeoRenderState)renderState)));
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(270.0f));
            } else if (livingRenderState.field_53455) {
                poseStack.method_46416(0.0f, (livingRenderState.field_53330 + 0.1f) / nativeScale, 0.0f);
                poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(GeoRenderState renderState) {
        return 90.0f;
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public R method_55269() {
        return null;
    }

    @ApiStatus.Internal
    public final R method_62425(T entity, float partialTick) {
        if (this.field_53189 == null) {
            this.field_53189 = this.createBaseRenderState(entity);
        }
        return (R)super.method_62425(entity, partialTick);
    }

    protected R createBaseRenderState(T entity) {
        return (R)(entity instanceof class_1309 ? new class_10042() : new class_10017());
    }

    @ApiStatus.OverrideOnly
    public void method_62354(T entity, R entityRenderState, float partialTick) {
        super.method_62354(entity, entityRenderState, partialTick);
        if (entityRenderState instanceof class_10042) {
            class_10042 livingEntityRenderState = (class_10042)entityRenderState;
            this.extractLivingEntityRenderState((class_1309)entity, livingEntityRenderState, partialTick, this.itemModelResolver);
        }
        this.fillRenderState((GeoAnimatable)entity, null, (GeoRenderState)entityRenderState, partialTick);
    }

    protected void extractLivingEntityRenderState(class_1309 entity, class_10042 renderState, float partialTick, class_10442 itemModelResolver) {
        class_1747 blockItem;
        class_310 minecraft = class_310.method_1551();
        float yHeadRot = class_3532.method_17821((float)partialTick, (float)entity.field_6259, (float)entity.field_6241);
        class_1799 helmetStack = entity.method_6118(class_1304.field_6169);
        renderState.field_53446 = class_922.method_62482((class_1309)entity, (float)yHeadRot, (float)partialTick);
        renderState.field_53447 = class_3532.method_15393((float)(yHeadRot - renderState.field_53446));
        renderState.field_53448 = entity.method_61414(partialTick);
        renderState.field_53464 = entity.method_5797();
        renderState.field_53455 = class_922.method_38563((class_1309)entity);
        if (renderState.field_53455) {
            renderState.field_53448 *= -1.0f;
            renderState.field_53447 *= -1.0f;
        }
        if (!entity.method_5765() && entity.method_5805()) {
            renderState.field_53450 = entity.field_42108.method_48572(partialTick);
            renderState.field_53451 = entity.field_42108.method_48570(partialTick);
        } else {
            renderState.field_53450 = 0.0f;
            renderState.field_53451 = 0.0f;
        }
        class_1297 class_12972 = entity.method_5854();
        if (class_12972 instanceof class_1309) {
            class_1309 vehicle = (class_1309)class_12972;
            renderState.field_53452 = vehicle.field_42108.method_48572(partialTick);
        } else {
            renderState.field_53452 = renderState.field_53450;
        }
        renderState.field_53453 = entity.method_55693();
        renderState.field_53454 = entity.method_17825();
        renderState.field_53465 = entity.method_18376();
        renderState.field_53463 = entity.method_18401();
        if (renderState.field_53463 != null) {
            renderState.field_53331 = entity.method_18381(class_4050.field_18076);
        }
        renderState.field_53456 = entity.method_32314();
        renderState.field_53457 = entity.method_6109();
        renderState.field_53458 = entity.method_5799();
        renderState.field_53459 = entity.method_6123();
        renderState.field_53460 = entity.field_6235 > 0 || entity.field_6213 > 0;
        class_1792 class_17922 = helmetStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2190) {
            class_2190 skullBlock = (class_2190)class_17922;
            renderState.field_55315 = skullBlock.method_9327();
            renderState.field_55316 = (class_9296)helmetStack.method_58694(class_9334.field_49617);
            renderState.field_53467.method_65605();
        } else {
            renderState.field_55315 = null;
            renderState.field_55316 = null;
            if (!class_970.method_64081((class_1799)helmetStack, (class_1304)class_1304.field_6169)) {
                itemModelResolver.method_65597(renderState.field_53467, helmetStack, class_811.field_4316, entity);
            } else {
                renderState.field_53467.method_65605();
            }
        }
        renderState.field_53449 = entity.field_6213 > 0 ? (float)entity.field_6213 + partialTick : 0.0f;
        renderState.field_53461 = renderState.field_53333 && entity.method_5756(ClientUtil.getClientPlayer());
        renderState.field_53462 = minecraft.method_27022((class_1297)entity);
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileEntityRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, Void relatedObject, R renderState) {
        GeckoLibServices.Client.EVENTS.fireCompileEntityRenderState(this, renderState, animatable);
    }

    @Override
    public boolean firePreRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
        return GeckoLibServices.Client.EVENTS.fireEntityPreRender(this, renderState, poseStack, model, bufferSource);
    }

    @Override
    public void firePostRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
        GeckoLibServices.Client.EVENTS.fireEntityPostRender(this, renderState, poseStack, model, bufferSource);
    }

    protected <S extends class_10042> S convertRenderStateToLiving(R renderState) {
        return (S)((class_10042)renderState);
    }
}

