/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtil;

public class GeoBlockRenderer<T extends class_2586>
implements GeoRenderer<T, Void, GeoRenderState>,
class_827<T> {
    protected final GeoRenderLayersContainer<T, Void, GeoRenderState> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f blockRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoBlockRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, Void, GeoRenderState>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoBlockRenderer<T> addRenderLayer(GeoRenderLayer<T, Void, GeoRenderState> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoBlockRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoBlockRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, Void relatedObject) {
        return animatable.method_11016().hashCode();
    }

    @Override
    @ApiStatus.Internal
    public GeoRenderState captureDefaultRenderState(T animatable, Void relatedObject, GeoRenderState renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        renderState.addGeckolibData(DataTickets.BLOCKSTATE, animatable.method_11010());
        renderState.addGeckolibData(DataTickets.BLOCKPOS, animatable.method_11016());
        renderState.addGeckolibData(DataTickets.POSITION, class_243.method_24953((class_2382)animatable.method_11016()));
        renderState.addGeckolibData(DataTickets.BLOCK_FACING, this.getFacing(animatable));
        return renderState;
    }

    @Override
    public void preRender(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            this.blockRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        }
    }

    @Override
    public void adjustPositionForRender(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
        if (!isReRender) {
            poseStack.method_22904(0.5, 0.0, 0.5);
        }
    }

    @Override
    public void scaleModelForRender(GeoRenderState renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, isReRender);
    }

    public void method_3569(T animatable, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_243 cameraPosition) {
        GeoRenderState.Impl renderState = this.fillRenderState(animatable, null, new GeoRenderState.Impl(), partialTick);
        renderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        this.defaultRender(renderState, poseStack, bufferSource, null, null);
    }

    @Override
    public void actuallyRender(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            this.rotateBlock(renderState.getGeckolibData(DataTickets.BLOCK_FACING), poseStack);
            this.getGeoModel().handleAnimations(this.createAnimationState(renderState));
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        }
    }

    @Override
    public void doPostRenderCleanup() {
        this.blockRenderTranslations = null;
        this.modelRenderTranslations = null;
    }

    @Override
    public void renderRecursively(GeoRenderState renderState, class_4587 poseStack, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, this.blockRenderTranslations);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            class_2338 pos = renderState.getGeckolibData(DataTickets.BLOCKPOS);
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix);
            bone.setWorldSpaceMatrix(worldState.translate((Vector3fc)new Vector3f((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260())));
        }
        GeoRenderer.super.renderRecursively(renderState, poseStack, bone, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
    }

    protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        switch (facing) {
            case field_11035: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40715.rotationDegrees(90.0f));
                break;
            }
            case field_11036: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11033: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(90.0f));
                break;
            }
        }
    }

    protected class_2350 getFacing(T blockEntity) {
        class_2680 blockState = blockEntity.method_11010();
        if (blockState.method_28498((class_2769)class_2383.field_11177)) {
            return (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        }
        if (blockState.method_28498((class_2769)class_2318.field_10927)) {
            return (class_2350)blockState.method_11654((class_2769)class_2318.field_10927);
        }
        return class_2350.field_11043;
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileBlockRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, Void relatedObject, GeoRenderState renderState) {
        GeckoLibServices.Client.EVENTS.fireCompileBlockRenderState(this, renderState, animatable);
    }

    @Override
    public boolean firePreRenderEvent(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
        return GeckoLibServices.Client.EVENTS.fireBlockPreRender(this, renderState, poseStack, model, bufferSource);
    }

    @Override
    public void firePostRenderEvent(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
        GeckoLibServices.Client.EVENTS.fireBlockPostRender(this, renderState, poseStack, model, bufferSource);
    }
}

