/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory.ecosystem;

import cz.mcsworld.eroded.config.debug.DebugConfig;
import cz.mcsworld.eroded.world.territory.TerritoryCell;
import cz.mcsworld.eroded.world.territory.TerritoryCellKey;
import cz.mcsworld.eroded.world.territory.TerritoryData;
import cz.mcsworld.eroded.world.territory.TerritoryStorage;
import cz.mcsworld.eroded.world.territory.TerritoryThreatResolver;
import cz.mcsworld.eroded.world.territory.TerritoryWorldState;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public final class TerritoryEcosystemTicker {
    private static final int INTERVAL_TICKS = 100;
    private static final int POLLUTION_REGEN_BLOCK = 50;
    private static final int POLLUTION_SCAR = 80;
    private static int counter = 0;

    private TerritoryEcosystemTicker() {
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(TerritoryEcosystemTicker::onTick);
    }

    private static void onTick(MinecraftServer server) {
        if (++counter < 100) {
            return;
        }
        counter = 0;
        for (class_3218 world : server.method_3738()) {
            TerritoryEcosystemTicker.tickWorld(world);
        }
    }

    private static void tickWorld(class_3218 world) {
        long tick = world.method_8503().method_3780();
        class_5819 random = world.method_8409();
        TerritoryWorldState state = TerritoryWorldState.get(world);
        for (class_3222 player : world.method_18456()) {
            class_1923 cp = new class_1923(player.method_24515());
            TerritoryCellKey key = TerritoryCellKey.fromChunk(cp.field_9181, cp.field_9180);
            TerritoryCell cell = state.getOrCreateCell(key);
            TerritoryData data = TerritoryStorage.get(world, cp);
            float threat = TerritoryThreatResolver.computeThreat(data, tick);
            int pollution = data.getPollution(tick);
            TerritoryEcosystemTicker.maybeErodeStone(world, key, cell, threat, random);
            if (threat > 0.6f) {
                TerritoryEcosystemTicker.maybeDegradeGrass(world, key, random);
            }
            if (threat < 0.25f && pollution < 50) {
                TerritoryEcosystemTicker.maybeRegrowGrass(world, key, random);
            }
            if (threat > 0.85f && pollution > 80) {
                TerritoryEcosystemTicker.maybeApplyPermanentScar(world, key, random);
            }
            TerritoryEcosystemTicker.maybePlayAtmosphere(world, key, threat, pollution, random);
        }
    }

    private static void maybeErodeStone(class_3218 world, TerritoryCellKey key, TerritoryCell cell, float threat, class_5819 random) {
        if (threat < 0.6f) {
            return;
        }
        if (cell.getMiningScore() < 300) {
            return;
        }
        if (random.method_43057() > 0.25f) {
            return;
        }
        class_1923 cp = TerritoryEcosystemTicker.randomChunkFromCell(key, random);
        if (!world.method_8393(cp.field_9181, cp.field_9180)) {
            return;
        }
        class_2338 pos = TerritoryEcosystemTicker.randomUndergroundPos(cp, random);
        if (world.method_8320(pos).method_27852(class_2246.field_10340)) {
            world.method_8652(pos, class_2246.field_10255.method_9564(), 2);
        }
    }

    private static void maybeDegradeGrass(class_3218 world, TerritoryCellKey key, class_5819 random) {
        if (random.method_43057() > 0.25f) {
            return;
        }
        class_1923 cp = TerritoryEcosystemTicker.randomChunkFromCell(key, random);
        if (!world.method_8393(cp.field_9181, cp.field_9180)) {
            return;
        }
        class_2338 groundPos = TerritoryEcosystemTicker.randomSurfacePos(world, cp, random);
        if (groundPos == null) {
            return;
        }
        class_2338 abovePos = groundPos.method_10084();
        class_2680 groundState = world.method_8320(groundPos);
        class_2680 aboveState = world.method_8320(abovePos);
        boolean changed = false;
        if (groundState.method_27852(class_2246.field_10219)) {
            world.method_8652(groundPos, class_2246.field_10253.method_9564(), 2);
            changed = true;
        }
        if (aboveState.method_27852(class_2246.field_10214) || aboveState.method_27852(class_2246.field_10479) || aboveState.method_27852(class_2246.field_10112) || aboveState.method_27852(class_2246.field_10313)) {
            world.method_22352(abovePos, false);
            changed = true;
        }
        if (changed && DebugConfig.get().ecosystem.enabled) {
            world.method_8503().method_3760().method_43514((class_2561)class_2561.method_43469((String)"eroded.ecosystem.surface_degraded", (Object[])new Object[]{cp.field_9181, cp.field_9180}), false);
        }
    }

    private static void maybeRegrowGrass(class_3218 world, TerritoryCellKey key, class_5819 random) {
        if (random.method_43057() > 0.01f) {
            return;
        }
        class_1923 cp = TerritoryEcosystemTicker.randomChunkFromCell(key, random);
        if (!world.method_8393(cp.field_9181, cp.field_9180)) {
            return;
        }
        class_2338 pos = TerritoryEcosystemTicker.randomSurfacePos(world, cp, random);
        if (pos == null) {
            return;
        }
        if (world.method_22339(pos.method_10084()) < 9) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10253)) {
            world.method_8652(pos, class_2246.field_10219.method_9564(), 2);
        } else if (state.method_27852(class_2246.field_10340) && random.method_43057() < 0.2f) {
            world.method_8652(pos, class_2246.field_28681.method_9564(), 2);
        }
    }

    private static void maybeApplyPermanentScar(class_3218 world, TerritoryCellKey key, class_5819 random) {
        if (random.method_43057() > 0.01f) {
            return;
        }
        class_1923 cp = TerritoryEcosystemTicker.randomChunkFromCell(key, random);
        if (!world.method_8393(cp.field_9181, cp.field_9180)) {
            return;
        }
        class_2338 pos = TerritoryEcosystemTicker.randomSurfacePos(world, cp, random);
        if (pos == null) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10253)) {
            world.method_8652(pos, class_2246.field_10520.method_9564(), 2);
        }
        if (state.method_27852(class_2246.field_10255)) {
            world.method_8652(pos, class_2246.field_27165.method_9564(), 2);
        }
        if (state.method_27852(class_2246.field_10340)) {
            world.method_8652(pos, class_2246.field_10115.method_9564(), 2);
        }
    }

    private static void maybePlayAtmosphere(class_3218 world, TerritoryCellKey key, float threat, int pollution, class_5819 random) {
        if (threat < 0.7f && pollution < 60) {
            return;
        }
        if (random.method_43057() > 0.05f) {
            return;
        }
        class_1923 cp = TerritoryEcosystemTicker.randomChunkFromCell(key, random);
        class_2338 pos = TerritoryEcosystemTicker.randomSurfacePos(world, cp, random);
        if (pos == null) {
            return;
        }
        if (world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 32.0, false) == null) {
            return;
        }
        world.method_65096((class_2394)class_2398.field_22247, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.2, (double)pos.method_10260() + 0.5, 6, 0.3, 0.2, 0.3, 0.01);
        if (random.method_43057() < 0.3f) {
            world.method_8396(null, pos, class_3417.field_17483, class_3419.field_15256, 0.3f, 0.7f);
        }
    }

    private static class_1923 randomChunkFromCell(TerritoryCellKey key, class_5819 random) {
        int baseX = key.cellX() * 3;
        int baseZ = key.cellZ() * 3;
        return new class_1923(baseX + random.method_43048(3), baseZ + random.method_43048(3));
    }

    private static class_2338 randomSurfacePos(class_3218 world, class_1923 cp, class_5819 random) {
        int z;
        int x = cp.method_8326() + random.method_43048(16);
        int y = world.method_8624(class_2902.class_2903.field_13203, x, z = cp.method_8328() + random.method_43048(16)) - 1;
        if (y < world.method_31607()) {
            return null;
        }
        return new class_2338(x, y, z);
    }

    private static class_2338 randomUndergroundPos(class_1923 cp, class_5819 random) {
        int x = cp.method_8326() + random.method_43048(16);
        int y = random.method_43048(40);
        int z = cp.method_8328() + random.method_43048(16);
        return new class_2338(x, y, z);
    }

    public static void forceTick(class_3218 world) {
        TerritoryEcosystemTicker.tickWorld(world);
    }
}

