/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory;

import cz.mcsworld.eroded.world.territory.TerritoryData;
import cz.mcsworld.eroded.world.territory.TerritoryStorage;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public final class TerritoryTracker {
    private TerritoryTracker() {
    }

    public static void onBlockPlaced(class_3218 world, class_2338 pos, class_2680 state) {
        long tick = world.method_8503().method_3780();
        TerritoryData data = TerritoryStorage.get(world, new class_1923(pos));
        class_2248 block = state.method_26204();
        int forest = TerritoryTracker.resolveForestationValue(block);
        int pollution = TerritoryTracker.resolvePollutionValue(block);
        if (forest > 0) {
            data.addForestation(forest, tick);
        }
        if (pollution > 0) {
            data.addPollution(pollution, tick);
        }
    }

    public static void onBlockBroken(class_3218 world, class_2338 pos, class_2680 state) {
        long tick = world.method_8503().method_3780();
        TerritoryData data = TerritoryStorage.get(world, new class_1923(pos));
        int mining = TerritoryTracker.resolveMiningValue(state, pos);
        if (mining > 0) {
            data.addMining(mining, tick);
        }
    }

    private static int resolveMiningValue(class_2680 state, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (block == class_2246.field_10340 || block == class_2246.field_28888) {
            return pos.method_10264() < 0 ? 2 : 1;
        }
        if (block == class_2246.field_10418 || block == class_2246.field_10212 || block == class_2246.field_27120 || block == class_2246.field_10571 || block == class_2246.field_10442 || block == class_2246.field_10080 || block == class_2246.field_10090 || block == class_2246.field_10013) {
            return 3;
        }
        return 0;
    }

    private static int resolveForestationValue(class_2248 block) {
        if (block == class_2246.field_10431 || block == class_2246.field_10037 || block == class_2246.field_10511 || block == class_2246.field_10306 || block == class_2246.field_10533 || block == class_2246.field_10010 || block == class_2246.field_37545 || block == class_2246.field_42729 || block == class_2246.field_41072) {
            return 2;
        }
        if (block == class_2246.field_10394 || block == class_2246.field_10217 || block == class_2246.field_10575 || block == class_2246.field_10276 || block == class_2246.field_10385 || block == class_2246.field_10160 || block == class_2246.field_42727 || block == class_2246.field_37544) {
            return 1;
        }
        return 0;
    }

    private static int resolvePollutionValue(class_2248 block) {
        if (block == class_2246.field_10181 || block == class_2246.field_16333 || block == class_2246.field_16334 || block == class_2246.field_17350 || block == class_2246.field_23860 || block == class_2246.field_10164 || block == class_2246.field_10092) {
            return 2;
        }
        return 0;
    }
}

