/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory;

import cz.mcsworld.eroded.world.territory.TerritoryData;

public final class TerritoryThreatResolver {
    private TerritoryThreatResolver() {
    }

    public static float computeThreat(TerritoryData data, long tick) {
        int mining = data.getMining(tick);
        int pollution = data.getPollution(tick);
        int forest = data.getForestation(tick);
        float miningN = TerritoryThreatResolver.clamp((float)mining / 100.0f, 0.0f, 1.0f);
        float pollutionN = TerritoryThreatResolver.clamp((float)pollution / 100.0f, 0.0f, 1.0f);
        float forestN = TerritoryThreatResolver.clamp((float)forest / 100.0f, 0.0f, 1.0f);
        float threat = miningN * 0.45f + pollutionN * 0.45f - forestN * 0.3f;
        return TerritoryThreatResolver.clamp(threat, 0.0f, 1.0f);
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }
}

