/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory;

import net.minecraft.class_2487;

public class TerritoryData {
    private int mining;
    private int forestation;
    private int pollution;
    private long lastTick;

    public int getMining(long tick) {
        this.applyDecay(tick);
        return this.mining;
    }

    public int getForestation(long tick) {
        this.applyDecay(tick);
        return this.forestation;
    }

    public int getPollution(long tick) {
        this.applyDecay(tick);
        return this.pollution;
    }

    public void addMining(int value, long tick) {
        this.applyDecay(tick);
        this.mining = Math.max(0, this.mining + value);
        this.lastTick = tick;
    }

    public void addForestation(int value, long tick) {
        this.applyDecay(tick);
        this.forestation = Math.max(0, this.forestation + value);
        this.lastTick = tick;
    }

    public void addPollution(int value, long tick) {
        this.applyDecay(tick);
        this.pollution = Math.max(0, this.pollution + value);
        this.lastTick = tick;
    }

    private void applyDecay(long tick) {
        if (this.lastTick == 0L) {
            this.lastTick = tick;
            return;
        }
        long elapsed = tick - this.lastTick;
        if (elapsed < 1200L) {
            return;
        }
        int steps = (int)(elapsed / 1200L);
        this.mining = Math.max(0, this.mining - steps);
        this.forestation = Math.max(0, this.forestation - steps);
        this.pollution = Math.max(0, this.pollution - steps);
        this.lastTick += (long)steps * 1200L;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("mining", this.mining);
        nbt.method_10569("forestation", this.forestation);
        nbt.method_10569("pollution", this.pollution);
        nbt.method_10544("lastTick", this.lastTick);
        return nbt;
    }

    public static TerritoryData fromNbt(class_2487 nbt) {
        TerritoryData d = new TerritoryData();
        nbt.method_10550("mining").ifPresent(v -> {
            d.mining = v;
        });
        nbt.method_10550("forestation").ifPresent(v -> {
            d.forestation = v;
        });
        nbt.method_10550("pollution").ifPresent(v -> {
            d.pollution = v;
        });
        nbt.method_10537("lastTick").ifPresent(v -> {
            d.lastTick = v;
        });
        return d;
    }
}

