/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.darkness;

import cz.mcsworld.eroded.network.DarknessStatePacket;
import cz.mcsworld.eroded.network.SafeNetworkUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class DarknessChecker {
    private static final Map<UUID, Boolean> LAST_STATE = new ConcurrentHashMap<UUID, Boolean>();
    private static int tickCounter = 0;

    private DarknessChecker() {
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(DarknessChecker::onTick);
    }

    private static void onTick(MinecraftServer server) {
        if (++tickCounter % 20 != 0) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            UUID id;
            boolean last;
            boolean inDarkness = DarknessChecker.isInDangerDarkness(player);
            if (inDarkness == (last = LAST_STATE.getOrDefault(id = player.method_5667(), false).booleanValue())) continue;
            LAST_STATE.put(id, inDarkness);
            SafeNetworkUtil.safeSend(player, new DarknessStatePacket(inDarkness));
        }
    }

    public static boolean isInDangerDarkness(class_3222 player) {
        int sky;
        class_2338 pos;
        class_3218 world = player.method_51469();
        int block = world.method_8314(class_1944.field_9282, pos = player.method_24515());
        int total = Math.max(block, sky = world.method_8314(class_1944.field_9284, pos));
        return total < 3;
    }

    public static boolean isInDangerDarkness(class_3218 world, class_2338 pos) {
        int sky;
        int block = world.method_8314(class_1944.field_9282, pos);
        int total = Math.max(block, sky = world.method_8314(class_1944.field_9284, pos));
        return total < 3;
    }
}

