/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.energy;

import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.network.EnergySyncPacket;
import cz.mcsworld.eroded.network.SafeNetworkUtil;
import cz.mcsworld.eroded.skills.SkillData;
import cz.mcsworld.eroded.skills.SkillManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class EnergySyncHandler {
    private static final Map<UUID, Integer> LAST_SENT = new ConcurrentHashMap<UUID, Integer>();

    private EnergySyncHandler() {
    }

    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> EnergySyncHandler.forceSync(handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> LAST_SENT.remove(handler.method_32311().method_5667()));
        ServerTickEvents.END_SERVER_TICK.register(EnergySyncHandler::tick);
    }

    private static void tick(MinecraftServer server) {
        EnergyConfig cfg = EnergyConfig.get();
        if (!cfg.warningsEnabled) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            int lastEnergy;
            SkillData data = SkillManager.get(player);
            int currentEnergy = data.getEnergy();
            boolean regenerating = currentEnergy > (lastEnergy = LAST_SENT.getOrDefault(player.method_5667(), currentEnergy).intValue());
            EnergySyncHandler.syncIfChanged(player);
        }
    }

    public static void syncIfChanged(class_3222 player) {
        int last;
        SkillData data = SkillManager.get(player);
        int energy = data.getEnergy();
        if (energy == (last = LAST_SENT.getOrDefault(player.method_5667(), Integer.MIN_VALUE).intValue())) {
            return;
        }
        LAST_SENT.put(player.method_5667(), energy);
        SafeNetworkUtil.safeSend(player, new EnergySyncPacket(energy));
    }

    public static void forceSync(class_3222 player) {
        SkillData data = SkillManager.get(player);
        int energy = data.getEnergy();
        LAST_SENT.put(player.method_5667(), energy);
        SafeNetworkUtil.safeSend(player, new EnergySyncPacket(energy));
    }
}

