/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.ui;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import snownee.jade.JadeInternals;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.api.ui.ResizeableElement;
import snownee.jade.gui.JadeLinearLayout;
import snownee.jade.impl.ui.JadeUIInternal;
import snownee.jade.overlay.DisplayHelper;

public abstract class Element
implements class_4068,
class_8021,
class_6383 {
    protected class_2960 tag;
    protected int width;
    protected int height;
    private int x;
    private int y;
    @Nullable
    private class_2561 narration = class_5244.field_39003;
    @Nullable
    private UnaryOperator<class_7847> settings;
    @Nullable
    private JadeLinearLayout.Align alignSelf;

    @Contract(value="_, _ -> new")
    public ResizeableElement offset(int x, int y) {
        return JadeUIInternal.offset(this, x, y);
    }

    @Contract(value="_, _ -> new")
    public ResizeableElement size(int width, int height) {
        return JadeUIInternal.size(this, width, height);
    }

    @Contract(value="_ -> new")
    public ResizeableElement onClick(Predicate<Element> onClick) {
        return JadeUIInternal.onClick(this, onClick);
    }

    @Contract(value="_ -> this")
    public Element settings(UnaryOperator<class_7847> settings) {
        this.settings = settings;
        return this;
    }

    @Nullable
    public UnaryOperator<class_7847> getSettings() {
        return this.settings;
    }

    @Contract(value="-> this")
    public Element alignSelfStart() {
        this.alignSelf = JadeLinearLayout.Align.START;
        return this;
    }

    @Contract(value="-> this")
    public Element alignSelfCenter() {
        this.alignSelf = JadeLinearLayout.Align.CENTER;
        return this;
    }

    @Contract(value="-> this")
    public Element alignSelfEnd() {
        this.alignSelf = JadeLinearLayout.Align.END;
        return this;
    }

    @Contract(value="-> this")
    public Element alignSelfStretch() {
        this.alignSelf = JadeLinearLayout.Align.STRETCH;
        return this;
    }

    @Nullable
    public JadeLinearLayout.Align getAlignSelf() {
        return this.alignSelf;
    }

    @Contract(value="_ -> this")
    public Element tag(@Nullable class_2960 tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    public class_2960 getTag() {
        return this.tag;
    }

    @Nullable
    public class_2561 cachedNarration() {
        if (this.narration == class_5244.field_39003) {
            this.narration = this.getNarration();
        }
        return this.narration;
    }

    @Nullable
    public abstract class_2561 getNarration();

    @Contract(value="-> this")
    public Element refreshNarration() {
        this.narration = class_5244.field_39003;
        return this;
    }

    @Contract(value="_ -> this")
    public Element narration(String narration) {
        Preconditions.checkNotNull((Object)narration, (Object)"narration must not be null");
        this.narration = narration.isEmpty() ? null : class_2561.method_43470((String)narration);
        return this;
    }

    @Contract(value="_ -> this")
    public Element narration(class_2561 narration) {
        Preconditions.checkNotNull((Object)narration, (Object)"narration must not be null");
        this.narration = narration;
        return this;
    }

    public abstract void method_25394(class_332 var1, int var2, int var3, float var4);

    public void method_46421(int x) {
        this.x = x;
    }

    public void method_46419(int y) {
        this.y = y;
    }

    public final int method_46426() {
        return this.x;
    }

    public final int method_46427() {
        return this.y;
    }

    public final int method_25368() {
        return this.width;
    }

    public final int method_25364() {
        return this.height;
    }

    public final class_8030 method_48202() {
        return super.method_48202();
    }

    public void method_48206(Consumer<class_339> consumer) {
    }

    public void method_37020(class_6382 narrationElementOutput) {
        class_2561 message = this.cachedNarration();
        if (message != null) {
            narrationElementOutput.method_37034(class_6381.field_33788, message);
        }
    }

    public void renderDebug(class_332 graphics, int mouseX, int mouseY, float partialTicks, RenderDebugContext context) {
        JadeInternals.getDisplayHelper().drawBorder(graphics, this.method_48202(), 1, -1996554240, true);
        if (class_437.method_25443() && this.getTag() != null) {
            int centerX = context.root.method_46426() + context.root.method_25368() / 2;
            int x = this.method_46426();
            int y = this.method_46427();
            String s = this.getTag().toString();
            int textWidth = DisplayHelper.font().method_1727(s);
            Matrix3x2fStack pose = graphics.method_51448();
            pose.pushMatrix();
            pose.translate((float)x, (float)y);
            pose.scale(0.5f);
            if (x > centerX) {
                pose.translate((float)(this.method_25368() + this.method_25368()), 0.0f);
            } else {
                pose.translate((float)(-textWidth - 4), 0.0f);
            }
            Objects.requireNonNull(DisplayHelper.font());
            graphics.method_25294(0, 0, textWidth + 4, 9 + 4, -2013265920);
            graphics.method_51433(DisplayHelper.font(), s, 2, 2, -1, false);
            pose.popMatrix();
        }
    }

    public static class RenderDebugContext {
        public final class_8021 root;
        public final Rect2f rootRect;

        public RenderDebugContext(class_8021 root, Rect2f rootRect) {
            this.root = root;
            this.rootRect = rootRect;
        }
    }
}

