/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.client.registry.display.DisplayGeneratorsRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.common.InternalLogger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface DisplayGeneratorsRegistryImpl
extends DisplayGeneratorsRegistry {
    public List<DynamicDisplayGenerator<?>> globalDisplayGenerators();

    public Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> categoryDisplayGenerators();

    @Override
    default public <A extends Display> void registerGlobalDisplayGenerator(DynamicDisplayGenerator<A> generator) {
        this.globalDisplayGenerators().add(generator);
        InternalLogger.getInstance().debug("Added global display generator: %s", generator);
    }

    @Override
    default public <A extends Display> void registerDisplayGenerator(CategoryIdentifier<A> categoryId, DynamicDisplayGenerator<A> generator) {
        this.categoryDisplayGenerators().computeIfAbsent(categoryId, location -> new ArrayList()).add(generator);
        InternalLogger.getInstance().debug("Added display generator for category [%s]: %s", categoryId, generator);
    }

    @Override
    default public List<DynamicDisplayGenerator<?>> getGlobalDisplayGenerators() {
        return Collections.unmodifiableList(this.globalDisplayGenerators());
    }

    @Override
    default public Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> getCategoryDisplayGenerators() {
        return Collections.unmodifiableMap(this.categoryDisplayGenerators());
    }
}

