/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.territory;

import cz.mcsworld.eroded.world.territory.TerritoryCell;
import cz.mcsworld.eroded.world.territory.TerritoryCellKey;
import cz.mcsworld.eroded.world.territory.TerritoryWorldState;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TerritoryCaveCollapseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Eroded-Collapse");
    private static final Random RANDOM = new Random();
    private static final long CELL_COOLDOWN_MS = 30000L;
    private static final int MINING_THRESHOLD = 300;
    private static final int STABILIZER_RADIUS = 3;
    private static final float MOB_SPAWN_CHANCE = 0.25f;
    private static final int MOB_SPAWN_ATTEMPTS = 5;
    private static final Map<TerritoryCellKey, Long> LAST_COLLAPSE = new HashMap<TerritoryCellKey, Long>();
    private static final class_1299<? extends class_1588>[] COLLAPSE_MOBS = new class_1299[]{class_1299.field_6051, class_1299.field_6137, class_1299.field_6079, class_1299.field_6046};

    private TerritoryCaveCollapseHandler() {
    }

    public static void register() {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = (class_3218)world;
            if (pos.method_10264() > 50) {
                return;
            }
            class_1923 chunk = new class_1923(pos);
            TerritoryCellKey key = TerritoryCellKey.fromChunk(chunk.field_9181, chunk.field_9180);
            long now = System.currentTimeMillis();
            if (now - LAST_COLLAPSE.getOrDefault(key, 0L) < 30000L) {
                return;
            }
            TerritoryWorldState stateData = TerritoryWorldState.get(serverWorld);
            TerritoryCell cell = stateData.getOrCreateCell(key);
            int score = cell.getMiningScore();
            if (score < 300) {
                return;
            }
            double chance = TerritoryCaveCollapseHandler.collapseChance(score);
            if (RANDOM.nextDouble() > chance) {
                return;
            }
            if (TerritoryCaveCollapseHandler.hasStabilizerNearby(serverWorld, pos)) {
                serverWorld.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14718, class_3419.field_15245, 0.5f, 1.2f);
                LOGGER.debug("Collapse prevented by stabilizer at {}", (Object)pos);
                return;
            }
            TerritoryCaveCollapseHandler.triggerCollapse(serverWorld, player, pos);
            LAST_COLLAPSE.put(key, now);
            LOGGER.info("Collapse triggered at {} (score={})", (Object)pos, (Object)score);
            if (RANDOM.nextFloat() < 0.25f) {
                TerritoryCaveCollapseHandler.trySpawnCollapseMob(serverWorld, player, pos);
            }
        });
    }

    private static double collapseChance(int miningScore) {
        if (miningScore < 500) {
            return 0.005;
        }
        if (miningScore < 1000) {
            return 0.02;
        }
        return 0.05;
    }

    private static boolean hasStabilizerNearby(class_3218 world, class_2338 origin) {
        class_2338.class_2339 check = new class_2338.class_2339();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    check.method_10103(origin.method_10263() + dx, origin.method_10264() + dy, origin.method_10260() + dz);
                    if (!TerritoryCaveCollapseHandler.isStabilizer(world.method_8320((class_2338)check))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isStabilizer(class_2680 state) {
        return state.method_27852(class_2246.field_10431) || state.method_27852(class_2246.field_10519);
    }

    private static void triggerCollapse(class_3218 world, class_1657 player, class_2338 origin) {
        class_2350 behind = player.method_5735().method_10153();
        int widthRadius = 1;
        int height = 3;
        int depth = 4;
        int startOffset = 2;
        world.method_8465(null, (double)origin.method_10263() + 0.5, (double)origin.method_10264() + 0.5, (double)origin.method_10260() + 0.5, (class_6880)class_3417.field_15152, class_3419.field_15245, 0.7f, 0.5f, world.method_8409().method_43055());
        class_2338 dustOrigin = origin.method_10079(behind, startOffset);
        world.method_65096((class_2394)class_2398.field_17430, (double)dustOrigin.method_10263() + 0.5, (double)dustOrigin.method_10264() + 1.0, (double)dustOrigin.method_10260() + 0.5, 20, 1.0, 1.0, 1.0, 0.05);
        for (int d = startOffset; d < startOffset + depth; ++d) {
            class_2338 center = origin.method_10079(behind, d);
            for (int w = -widthRadius; w <= widthRadius; ++w) {
                for (int h = 1; h <= height; ++h) {
                    class_2338 target = center.method_10086(h);
                    target = behind.method_10166() == class_2350.class_2351.field_11048 ? target.method_10069(0, 0, w) : target.method_10069(w, 0, 0);
                    class_2680 state = world.method_8320(target);
                    if (!TerritoryCaveCollapseHandler.isCollapsable(state)) continue;
                    world.method_8652(target, class_2246.field_10255.method_9564(), 18);
                    if (RANDOM.nextInt(3) != 0) continue;
                    world.method_65096((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10255.method_9564()), (double)target.method_10263() + 0.5, (double)target.method_10264() + 0.5, (double)target.method_10260() + 0.5, 1, 0.1, 0.1, 0.1, 0.05);
                }
            }
        }
    }

    private static boolean isCollapsable(class_2680 state) {
        return state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_28888) || state.method_27852(class_2246.field_27165) || state.method_27852(class_2246.field_10115) || state.method_27852(class_2246.field_10508) || state.method_27852(class_2246.field_10474);
    }

    private static void trySpawnCollapseMob(class_3218 world, class_1657 player, class_2338 origin) {
        class_2350 behind = player.method_5735().method_10153();
        for (int i = 0; i < 5; ++i) {
            class_2338 basePos = origin.method_10079(behind, 4 + RANDOM.nextInt(4));
            class_2338 spawnPos = basePos.method_10086(RANDOM.nextInt(2));
            if (!world.method_22347(spawnPos) || !world.method_22347(spawnPos.method_10084()) || spawnPos.method_19771((class_2382)player.method_24515(), 6.0)) continue;
            class_1299<? extends class_1588> type = COLLAPSE_MOBS[RANDOM.nextInt(COLLAPSE_MOBS.length)];
            class_1588 mob = (class_1588)type.method_5899(world, null, spawnPos, class_3730.field_16467, true, false);
            if (mob == null) {
                return;
            }
            LOGGER.info("Collapse attracted {} at {}", (Object)mob.method_5864().method_5882(), (Object)spawnPos);
            return;
        }
    }
}

