/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.world.darkness;

import cz.mcsworld.eroded.world.darkness.DarknessFlickerEffects;
import cz.mcsworld.eroded.world.darkness.DarknessFlickerState;
import cz.mcsworld.eroded.world.darkness.DarknessLightConsumeEffects;
import cz.mcsworld.eroded.world.darkness.DarknessLightMemory;
import cz.mcsworld.eroded.world.darkness.DarknessMobLightMemory;
import cz.mcsworld.eroded.world.territory.TerritoryData;
import cz.mcsworld.eroded.world.territory.TerritoryStorage;
import cz.mcsworld.eroded.world.territory.TerritoryThreatResolver;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1588;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3922;
import net.minecraft.server.MinecraftServer;

public final class DarknessLightEater {
    private static final int CHECK_INTERVAL = 40;
    private static final int RADIUS = 2;
    private static final int MAX_ACTIONS_PER_TICK = 6;
    private static int tickCounter = 0;
    private static int actions = 0;

    private DarknessLightEater() {
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(DarknessLightEater::onTick);
    }

    private static void onTick(MinecraftServer server) {
        if (++tickCounter % 40 != 0) {
            return;
        }
        actions = 0;
        for (class_3218 world : server.method_3738()) {
            long tick = world.method_8503().method_3780();
            HashMap<class_1923, Float> threatCache = new HashMap<class_1923, Float>();
            for (class_1588 mob : world.method_8390(class_1588.class, class_238.method_30048((class_243)class_243.method_24954((class_2382)world.method_43126()), (double)256.0, (double)256.0, (double)256.0), e -> e.method_5752().contains("eroded_mutated"))) {
                if (actions >= 6) {
                    return;
                }
                DarknessLightEater.tryExtinguish(world, mob, threatCache, tick);
            }
        }
    }

    private static void tryExtinguish(class_3218 world, class_1588 mob, Map<class_1923, Float> threatCache, long tick) {
        class_2338 center = mob.method_24515();
        class_1923 cp = new class_1923(center);
        float threat = threatCache.computeIfAbsent(cp, c -> {
            TerritoryData d = TerritoryStorage.get(world, c);
            return Float.valueOf(TerritoryThreatResolver.computeThreat(d, tick));
        }).floatValue();
        if (threat < 0.6f) {
            return;
        }
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    pos.method_10103(center.method_10263() + dx, center.method_10264() + dy, center.method_10260() + dz);
                    class_2680 state = world.method_8320((class_2338)pos);
                    class_2248 block = state.method_26204();
                    if (!DarknessLightEater.isLightSource(block)) continue;
                    ++actions;
                    if (!DarknessLightMemory.has((class_2338)pos)) {
                        DarknessLightMemory.store((class_2338)pos, state);
                    }
                    boolean destroy = DarknessFlickerState.advance((class_2338)pos);
                    DarknessFlickerEffects.play(world, (class_2338)pos);
                    if (destroy) {
                        DarknessLightConsumeEffects.play(world, (class_2338)pos);
                        world.method_22352((class_2338)pos, false);
                        for (class_1588 nearby : world.method_8390(class_1588.class, new class_238((class_2338)pos).method_1014(6.0), e -> true)) {
                            DarknessMobLightMemory.markLightExtinguished(nearby);
                        }
                        DarknessLightMemory.clear((class_2338)pos);
                        DarknessFlickerState.clear((class_2338)pos);
                    } else {
                        DarknessLightEater.applyDimVariant(world, (class_2338)pos, state);
                    }
                    return;
                }
            }
        }
    }

    private static void applyDimVariant(class_3218 world, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        if (block == class_2246.field_10336 || block == class_2246.field_10099) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
        if (block == class_2246.field_17350) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private static boolean isLightSource(class_2248 block) {
        return block == class_2246.field_10336 || block == class_2246.field_10099 || block == class_2246.field_16541 || block == class_2246.field_22110 || block == class_2246.field_17350;
    }
}

