/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.skills;

import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.skills.SkillType;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillData {
    private final Map<SkillType, Float> cgMap = new EnumMap<SkillType, Float>(SkillType.class);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ErodedEnergy");
    private int energy;
    private long lastRegenTime = System.currentTimeMillis();
    private boolean collapsed = false;
    private long collapseUntilMs = 0L;
    private EnergyState lastEnergyState = EnergyState.NORMAL;
    private int lastFlashes = -1;

    public SkillData() {
        for (SkillType type : SkillType.values()) {
            this.cgMap.put(type, Float.valueOf(0.0f));
        }
    }

    public float getCg(SkillType type) {
        return this.cgMap.getOrDefault((Object)type, Float.valueOf(0.0f)).floatValue();
    }

    public void addCg(SkillType type, float baseAmount) {
        float current = this.getCg(type);
        if (current >= 100.0f) {
            return;
        }
        float multiplier = 1.0f - current / 120.0f;
        float gained = baseAmount * Math.max(multiplier, 0.05f);
        this.cgMap.put(type, Float.valueOf(Math.min(current + gained, 100.0f)));
    }

    public void setCg(SkillType type, float value) {
        this.cgMap.put(type, Float.valueOf(Math.max(0.0f, Math.min(100.0f, value))));
    }

    public int getEnergy() {
        this.regenerateEnergy();
        return this.energy;
    }

    public int getMaxEnergy() {
        return this.getConfig().maxEnergy;
    }

    public boolean hasEnoughEnergy(int amount) {
        this.regenerateEnergy();
        return !this.collapsed && this.energy >= amount;
    }

    public void consumeEnergy(int amount) {
        if (this.collapsed || amount <= 0) {
            return;
        }
        this.energy = Math.max(0, this.energy - amount);
        if (this.energy == 0) {
            this.enterCollapse();
            return;
        }
        this.regenerateEnergy();
    }

    public EnergyState getEnergyState() {
        return this.lastEnergyState;
    }

    public void addEnergy(int amount) {
        this.regenerateEnergy();
        if (amount <= 0) {
            return;
        }
        this.energy = Math.min(this.getMaxEnergy(), this.energy + amount);
    }

    public void setEnergy(int value) {
        this.energy = Math.max(0, Math.min(this.getMaxEnergy(), value));
        this.collapsed = false;
    }

    public void setEnergyAfterDeath(float ratio) {
        int target = Math.max(0, (int)((float)this.getMaxEnergy() * ratio));
        this.setEnergy(target);
    }

    public void initialize() {
        this.energy = this.getMaxEnergy();
        this.collapsed = false;
        this.lastRegenTime = System.currentTimeMillis();
    }

    private void enterCollapse() {
        EnergyConfig cfg = this.getConfig();
        this.collapsed = true;
        this.collapseUntilMs = System.currentTimeMillis() + (long)cfg.collapseDelayMs;
    }

    private void regenerateEnergy() {
        EnergyConfig cfg = this.getConfig();
        long now = System.currentTimeMillis();
        if (this.collapsed) {
            if (now < this.collapseUntilMs) {
                return;
            }
            this.energy = 1;
            this.collapsed = false;
            this.lastRegenTime = now;
            return;
        }
        if (!cfg.passiveRegenEnabled) {
            return;
        }
        long elapsed = now - this.lastRegenTime;
        long intervalMs = (long)cfg.regenIntervalSeconds * 1000L;
        if (elapsed < intervalMs) {
            return;
        }
        int restoredSegments = (int)(elapsed / intervalMs);
        int restoreAmount = restoredSegments * cfg.energyPerSegment;
        if (restoreAmount > 0) {
            this.energy = Math.min(this.getMaxEnergy(), this.energy + restoreAmount);
            this.lastRegenTime += (long)restoredSegments * intervalMs;
        }
    }

    public boolean areFlashesDecreasing() {
        EnergyConfig cfg = this.getConfig();
        int flashes = this.getCurrentFlashes(cfg);
        if (this.lastFlashes == -1) {
            this.lastFlashes = flashes;
            return false;
        }
        boolean decreasing = flashes < this.lastFlashes;
        this.lastFlashes = flashes;
        return decreasing;
    }

    private int getCurrentFlashes(EnergyConfig cfg) {
        float energyPerFlash = (float)this.getMaxEnergy() / (float)cfg.numberEnergyFlashes;
        return (int)((float)this.energy / energyPerFlash);
    }

    private EnergyConfig getConfig() {
        return EnergyConfig.get();
    }

    public boolean tryConsumeEnergy(int amount) {
        if (!this.hasEnoughEnergy(amount)) {
            return false;
        }
        this.consumeEnergy(amount);
        return true;
    }

    public boolean canAffordEnergy(int amount) {
        return !this.collapsed && this.energy >= amount;
    }

    public static enum EnergyState {
        NORMAL,
        TIRED,
        EXHAUSTED,
        EMPTY;

    }
}

