/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.mixin;

import cz.mcsworld.eroded.config.crafting.CraftingConfig;
import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.crafting.CraftingCgResolver;
import cz.mcsworld.eroded.crafting.CraftingQualityApplier;
import cz.mcsworld.eroded.crafting.CraftingSkillResolver;
import cz.mcsworld.eroded.crafting.InputQualityResolver;
import cz.mcsworld.eroded.crafting.Quality;
import cz.mcsworld.eroded.crafting.QualityApplicable;
import cz.mcsworld.eroded.crafting.QualityResolver;
import cz.mcsworld.eroded.crafting.RecipeDifficulty;
import cz.mcsworld.eroded.crafting.RecipeDifficultyResolver;
import cz.mcsworld.eroded.energy.EnergyCostResolver;
import cz.mcsworld.eroded.mixin.CraftingResultSlotAccessor;
import cz.mcsworld.eroded.network.CraftingFailPacket;
import cz.mcsworld.eroded.network.EnergySyncPacket;
import cz.mcsworld.eroded.network.SafeNetworkUtil;
import cz.mcsworld.eroded.skills.SkillData;
import cz.mcsworld.eroded.skills.SkillManager;
import cz.mcsworld.eroded.skills.SkillType;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1734;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8566;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1734.class})
public class CraftingResultSlotMixin {
    @Inject(method={"method_7667(Lnet/minecraft/class_1657;Lnet/minecraft/class_1799;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void eroded$onTakeItem(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (stack == null || stack.method_7960()) {
            return;
        }
        class_1734 self = (class_1734)this;
        class_8566 inputInv = ((CraftingResultSlotAccessor)self).eroded$getInput();
        ArrayList<class_1799> actualInputs = new ArrayList<class_1799>();
        for (int i = 0; i < inputInv.method_5439(); ++i) {
            class_1799 inputStack = inputInv.method_5438(i);
            if (inputStack.method_7960()) continue;
            actualInputs.add(inputStack);
        }
        SkillData data = SkillManager.get(serverPlayer);
        EnergyConfig energyCfg = EnergyConfig.get();
        CraftingConfig craftingCfg = CraftingConfig.get();
        float avgInputQuality = InputQualityResolver.resolveAverage(actualInputs);
        RecipeDifficulty difficulty = RecipeDifficultyResolver.resolve(stack);
        boolean applyQuality = QualityApplicable.isApplicable(stack);
        Quality quality = Quality.STANDARD;
        if (applyQuality) {
            quality = QualityResolver.resolveQuality(data, avgInputQuality);
        }
        float diffEnergyMult = switch (difficulty) {
            default -> throw new MatchException(null, null);
            case RecipeDifficulty.SIMPLE -> craftingCfg.simpleRecipeEnergyMultiplier;
            case RecipeDifficulty.NORMAL -> craftingCfg.normalRecipeEnergyMultiplier;
            case RecipeDifficulty.COMPLEX -> craftingCfg.complexRecipeEnergyMultiplier;
        };
        int rawBase = EnergyCostResolver.getBaseCraftingCostFromInputs(actualInputs);
        int baseCost = Math.round((float)rawBase * diffEnergyMult);
        float qualityEnergyMult = switch (quality) {
            default -> throw new MatchException(null, null);
            case Quality.POOR -> craftingCfg.poorQualityEnergyMultiplier;
            case Quality.STANDARD -> craftingCfg.standardQualityEnergyMultiplier;
            case Quality.EXCELLENT -> craftingCfg.excellentQualityEnergyMultiplier;
        };
        int energyCost = Math.max(craftingCfg.minimumCraftCost, Math.round((float)baseCost * qualityEnergyMult));
        if (!data.canAffordEnergy(energyCost) && energyCfg.blockWorkAtZero) {
            serverPlayer.method_5682().execute(() -> SafeNetworkUtil.safeSend(serverPlayer, new CraftingFailPacket()));
            stack.method_7939(0);
            ci.cancel();
            return;
        }
        data.consumeEnergy(energyCost);
        SafeNetworkUtil.safeSend(serverPlayer, new EnergySyncPacket(data.getEnergy()));
        SkillType skill = CraftingSkillResolver.resolve(stack);
        float baseCg = CraftingCgResolver.getBaseCg(stack);
        float diffCgMult = switch (difficulty) {
            default -> throw new MatchException(null, null);
            case RecipeDifficulty.SIMPLE -> craftingCfg.simpleRecipeCgMultiplier;
            case RecipeDifficulty.NORMAL -> craftingCfg.normalRecipeCgMultiplier;
            case RecipeDifficulty.COMPLEX -> craftingCfg.complexRecipeCgMultiplier;
        };
        data.addCg(skill, baseCg * diffCgMult);
        if (applyQuality) {
            CraftingQualityApplier.apply(stack, quality);
        }
    }
}

