/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.death;

import cz.mcsworld.eroded.config.death.DeathConfig;
import cz.mcsworld.eroded.core.ErodedItems;
import cz.mcsworld.eroded.death.DeathChestState;
import cz.mcsworld.eroded.death.DeathDistanceHelper;
import cz.mcsworld.eroded.death.DeathHologramHandler;
import cz.mcsworld.eroded.death.DeathValueCalculator;
import cz.mcsworld.eroded.death.ErodedCompassHandler;
import cz.mcsworld.eroded.death.ErodedDeathMemory;
import cz.mcsworld.eroded.death.ErodedDeathStorage;
import cz.mcsworld.eroded.death.block.ErodedBlocks;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public final class DeathChestHandler {
    private DeathChestHandler() {
    }

    public static void register() {
        ServerLivingEntityEvents.ALLOW_DEATH.register(DeathChestHandler::onDeath);
    }

    private static boolean onDeath(class_1309 entity, class_1282 source, float damage) {
        if (!(entity instanceof class_3222)) {
            return true;
        }
        class_3222 player = (class_3222)entity;
        class_3218 class_32182 = player.method_51469();
        if (!(class_32182 instanceof class_3218)) {
            return true;
        }
        class_3218 world = class_32182;
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 s = inv.method_5438(i);
            if (s.method_7960() || !s.method_31574(ErodedItems.DEATH_COMPASS)) continue;
            inv.method_5447(i, class_1799.field_8037);
        }
        boolean hasItems = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            if (inv.method_5438(i).method_7960()) continue;
            hasItems = true;
            break;
        }
        if (!hasItems) {
            return true;
        }
        UUID hologramId = UUID.randomUUID();
        class_2338 chestPos = DeathChestHandler.findSurfacePos(world, player.method_24515());
        world.method_8501(chestPos, ErodedBlocks.DEATH_ENDER_CHEST.method_9564());
        ArrayList<class_1799> snapshot = new ArrayList<class_1799>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            snapshot.add(inv.method_5438(i));
            inv.method_5447(i, class_1799.field_8037);
        }
        player.method_31548().method_61496(0);
        long deathValue = DeathValueCalculator.calculate(snapshot);
        long baseTimeMs = (long)DeathConfig.get().chest.protectionTicks * 50L;
        double dist = DeathDistanceHelper.getDeathToWorldSpawnDistance(player, chestPos, (class_5321<class_1937>)world.method_27983());
        long extraTimeMs = dist >= 0.0 ? Math.round(dist * 450.0) : 0L;
        long untilEpochMs = System.currentTimeMillis() + baseTimeMs + extraTimeMs;
        ErodedDeathMemory memory = new ErodedDeathMemory(chestPos, (class_5321<class_1937>)world.method_27983(), untilEpochMs, deathValue, hologramId);
        boolean accepted = ErodedDeathStorage.putIfMoreValuable(player.method_5667(), memory);
        Map<Integer, DeathChestState.StoredStack> stored = DeathChestState.fromInventory(snapshot);
        DeathChestState.get(world).put(chestPos, player.method_5667(), untilEpochMs, stored, hologramId);
        ErodedCompassHandler.onPlayerDeath(player, chestPos, accepted);
        int remainingSeconds = (int)((untilEpochMs - System.currentTimeMillis()) / 1000L);
        DeathHologramHandler.spawn(world, chestPos, player.method_7334(), remainingSeconds, hologramId);
        return true;
    }

    private static class_2338 findSurfacePos(class_3218 world, class_2338 startPos) {
        if (world.method_8316(startPos).method_15769()) {
            return world.method_8320(startPos).method_26215() ? startPos : startPos.method_10084();
        }
        for (int r = 1; r <= 6; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    for (int yOff : new int[]{0, 1, -1}) {
                        class_2338 checkPos = startPos.method_10069(x, yOff, z);
                        if (!world.method_8316(checkPos).method_15769() || !world.method_8320(checkPos).method_45474()) continue;
                        return checkPos;
                    }
                }
            }
        }
        class_2338.class_2339 mutablePos = startPos.method_25503();
        int searchLimit = Math.min(startPos.method_10264() + 45, world.method_31600() - 3);
        while (mutablePos.method_10264() < searchLimit && !world.method_8316((class_2338)mutablePos).method_15769()) {
            mutablePos.method_10100(0, 1, 0);
        }
        return mutablePos.method_10062();
    }
}

