/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import cz.mcsworld.eroded.config.ErodedConfigs;
import cz.mcsworld.eroded.world.territory.TerritoryData;
import cz.mcsworld.eroded.world.territory.TerritoryStorage;
import cz.mcsworld.eroded.world.territory.TerritoryThreatResolver;
import cz.mcsworld.eroded.world.territory.ecosystem.TerritoryEcosystemTicker;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class ErodedCommand {
    private ErodedCommand() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ErodedCommand.registerInternal((CommandDispatcher<class_2168>)dispatcher));
    }

    private static void registerInternal(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eroded").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"reload").executes(ctx -> {
            ErodedConfigs.reload();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7a[Eroded] Konfigurace byla znovu na\u010dtena."), false);
            return 1;
        }))).then(class_2170.method_9247((String)"force").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            TerritoryEcosystemTicker.forceTick(player.method_51469());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7c[Ecosystem] FORCE tick proveden."), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"territory").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            class_3218 world = player.method_51469();
            long tick = world.method_8503().method_3780();
            class_1923 cp = new class_1923(player.method_24515());
            TerritoryData data = TerritoryStorage.get(world, cp);
            int mining = data.getMining(tick);
            int forest = data.getForestation(tick);
            int pollution = data.getPollution(tick);
            float threat = TerritoryThreatResolver.computeThreat(data, tick);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76[\u00dazem\u00ed]\n\u00a77Chunk: \u00a7f" + cp.field_9181 + " / " + cp.field_9180 + "\n\u00a77T\u011b\u017eba: \u00a7f" + mining + "\n\u00a77Zalesn\u011bn\u00ed: \u00a7f" + forest + "\n\u00a77Zne\u010di\u0161t\u011bn\u00ed: \u00a7f" + pollution + "\n\u00a77Hrozba: \u00a7f" + String.format("%.2f", Float.valueOf(threat)))), false);
            return 1;
        })).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> ErodedCommand.modifyTerritory((class_2168)ctx.getSource(), (String)ctx.getArgument("type", String.class), (Integer)ctx.getArgument("value", Integer.class), false)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ErodedCommand.modifyTerritory((class_2168)ctx.getSource(), (String)ctx.getArgument("type", String.class), (Integer)ctx.getArgument("value", Integer.class), true)))))).then(class_2170.method_9247((String)"reset").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            class_3218 world = player.method_51469();
            long tick = world.method_8503().method_3780();
            TerritoryData data = TerritoryStorage.get(world, new class_1923(player.method_24515()));
            data.addMining(-data.getMining(tick), tick);
            data.addForestation(-data.getForestation(tick), tick);
            data.addPollution(-data.getPollution(tick), tick);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7a[\u00dazem\u00ed] Hodnoty byly resetov\u00e1ny."), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ecosystem").then(class_2170.method_9247((String)"tick").executes(ctx -> {
            MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
            TerritoryEcosystemTicker.register();
            server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a7e[Ekosyst\u00e9m] Testovac\u00ed tick byl spu\u0161t\u011bn."), false);
            return 1;
        }))).then(class_2170.method_9247((String)"preview").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            class_3218 world = player.method_51469();
            long tick = world.method_8503().method_3780();
            TerritoryData data = TerritoryStorage.get(world, new class_1923(player.method_24515()));
            float threat = TerritoryThreatResolver.computeThreat(data, tick);
            int pollution = data.getPollution(tick);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76[N\u00e1hled ekosyst\u00e9mu]\n\u00a77Degradace: \u00a7f" + (threat > 0.6f) + "\n\u00a77Regenerace: \u00a7f" + (threat < 0.25f && pollution < 50) + "\n\u00a77Trval\u00e9 jizvy: \u00a7f" + (threat > 0.85f && pollution > 80))), false);
            return 1;
        })))));
    }

    private static int modifyTerritory(class_2168 source, String type, int value, boolean absolute) {
        class_3222 player = source.method_44023();
        class_3218 world = player.method_51469();
        long tick = world.method_8503().method_3780();
        TerritoryData data = TerritoryStorage.get(world, new class_1923(player.method_24515()));
        switch (type.toLowerCase()) {
            case "mining": {
                int current = data.getMining(tick);
                data.addMining(absolute ? value - current : value, tick);
                break;
            }
            case "forest": 
            case "forestation": {
                int current = data.getForestation(tick);
                data.addForestation(absolute ? value - current : value, tick);
                break;
            }
            case "pollution": {
                int current = data.getPollution(tick);
                data.addPollution(absolute ? value - current : value, tick);
                break;
            }
            default: {
                source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cNezn\u00e1m\u00fd typ hodnoty: " + type)));
                return 0;
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7a[\u00dazem\u00ed] Hodnota '" + type + "' byla upravena.")), false);
        return 1;
    }
}

