/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.client.hud;

import cz.mcsworld.eroded.client.data.ClientEnergyData;
import cz.mcsworld.eroded.client.hud.EnergyHudLogic;
import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.skills.SkillData;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class EnergyHud
implements HudRenderCallback {
    private static final String ICON = "\u26a1";
    private static int lastEnergyValue = -1;
    private static boolean isRegenerating = false;
    private static int warningTicks = 0;
    private static SkillData.EnergyState lastKnownState = SkillData.EnergyState.NORMAL;

    public void onHudRender(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || !ClientEnergyData.isInitialized()) {
            return;
        }
        EnergyConfig cfg = EnergyConfig.get();
        if (!cfg.energyHudEnabled) {
            return;
        }
        int energy = ClientEnergyData.getEnergy();
        int maxEnergy = ClientEnergyData.getMaxEnergy();
        if (maxEnergy <= 0) {
            maxEnergy = cfg.maxEnergy;
        }
        if (energy > lastEnergyValue && lastEnergyValue != -1) {
            isRegenerating = true;
        } else if (energy < lastEnergyValue) {
            isRegenerating = false;
        }
        if (energy >= maxEnergy) {
            isRegenerating = false;
        }
        lastEnergyValue = energy;
        if (!cfg.showHudWhenFull && energy >= maxEnergy) {
            return;
        }
        SkillData.EnergyState currentState = EnergyHudLogic.getCurrentState(energy, maxEnergy);
        if (!isRegenerating && currentState != SkillData.EnergyState.NORMAL && currentState != lastKnownState) {
            warningTicks = cfg.WarningMessageTime;
        }
        lastKnownState = currentState;
        int total = cfg.numberEnergyFlashes;
        int ticks = client.field_1705.method_1738();
        int screenW = context.method_51421();
        int screenH = context.method_51443();
        int x = screenW / 2 - 91;
        int y = screenH - 49;
        for (int i = 0; i < total; ++i) {
            int drawX = x + i * 8;
            EnergyHudLogic.SegmentVisual visual = EnergyHudLogic.resolve(i, total, energy, maxEnergy, isRegenerating, ticks);
            if (!visual.visible()) {
                context.method_51433(client.field_1772, ICON, drawX, y, -11184811, true);
                continue;
            }
            Matrix3x2fStack matrices = context.method_51448();
            matrices.pushMatrix();
            float cx = drawX + 4;
            float cy = y + 4;
            matrices.translate(cx, cy);
            matrices.scale(visual.scale(), visual.scale());
            matrices.translate(-cx, -cy);
            context.method_51433(client.field_1772, ICON, drawX, y, 0xFF000000 | visual.color() & 0xFFFFFF, true);
            matrices.popMatrix();
        }
        if (warningTicks > 0 && !isRegenerating) {
            String key = EnergyHudLogic.getWarningTranslationKey(currentState);
            if (key != null) {
                class_5250 text = class_2561.method_43471((String)key);
                int textWidth = client.field_1772.method_27525((class_5348)text);
                int textX = (screenW - textWidth) / 2;
                int textY = y - 10;
                context.method_51439(client.field_1772, (class_2561)text, textX, textY, -43691, true);
                --warningTicks;
            } else {
                warningTicks = 0;
            }
        }
    }
}

