/*
 * Decompiled with CFR 0.152.
 */
package cz.mcsworld.eroded.client.gui;

import cz.mcsworld.eroded.client.data.ClientEnergyData;
import cz.mcsworld.eroded.client.hud.EnergyHudLogic;
import cz.mcsworld.eroded.config.energy.EnergyConfig;
import cz.mcsworld.eroded.skills.SkillData;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.joml.Matrix3x2fStack;

public final class EnergyScreenOverlay {
    private static final String ICON = "\u26a1";
    private static int lastEnergyValue = -1;
    private static boolean isRegenerating = false;
    private static int craftingFailTicks = 0;
    private static int energyWarningTicks = 0;
    private static SkillData.EnergyState lastKnownState = SkillData.EnergyState.NORMAL;

    private EnergyScreenOverlay() {
    }

    public static void register() {
        ScreenEvents.AFTER_INIT.register((client, screen, w, h) -> ScreenEvents.afterRender((class_437)screen).register(EnergyScreenOverlay::render));
    }

    private static void render(class_437 screen, class_332 context, int mouseX, int mouseY, float delta) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || !ClientEnergyData.isInitialized()) {
            return;
        }
        EnergyConfig cfg = EnergyConfig.get();
        if (!cfg.energyHudEnabled) {
            return;
        }
        int energy = ClientEnergyData.getEnergy();
        int maxEnergy = ClientEnergyData.getMaxEnergy();
        if (maxEnergy <= 0) {
            maxEnergy = cfg.maxEnergy;
        }
        if (energy > lastEnergyValue && lastEnergyValue != -1) {
            isRegenerating = true;
        } else if (energy < lastEnergyValue) {
            isRegenerating = false;
        }
        if (energy >= maxEnergy) {
            isRegenerating = false;
        }
        lastEnergyValue = energy;
        SkillData.EnergyState currentState = EnergyHudLogic.getCurrentState(energy, maxEnergy);
        if (!isRegenerating && currentState != SkillData.EnergyState.NORMAL && currentState != lastKnownState) {
            energyWarningTicks = cfg.WarningMessageTime;
        }
        lastKnownState = currentState;
        int total = cfg.numberEnergyFlashes;
        int ticks = client.field_1705.method_1738();
        int screenW = context.method_51421();
        int barWidth = total * 8;
        int iconsX = (screenW - barWidth) / 2;
        int barCenterX = iconsX + barWidth / 2;
        int iconsY = 8;
        for (int i = 0; i < total; ++i) {
            int drawX = iconsX + i * 8;
            EnergyHudLogic.SegmentVisual visual = EnergyHudLogic.resolve(i, total, energy, maxEnergy, isRegenerating, ticks);
            if (!visual.visible()) {
                context.method_51433(client.field_1772, ICON, drawX, iconsY, -11184811, true);
                continue;
            }
            Matrix3x2fStack matrices = context.method_51448();
            matrices.pushMatrix();
            float cx = drawX + 4;
            float cy = iconsY + 4;
            matrices.translate(cx, cy);
            matrices.scale(visual.scale(), visual.scale());
            matrices.translate(-cx, -cy);
            context.method_51433(client.field_1772, ICON, drawX, iconsY, 0xFF000000 | visual.color() & 0xFFFFFF, true);
            matrices.popMatrix();
        }
        class_5250 textToDraw = null;
        int textColor = -1;
        if (craftingFailTicks > 0) {
            textToDraw = class_2561.method_43471((String)"eroded.crafting.not_enough_energy");
            textColor = -43691;
            --craftingFailTicks;
        } else if (energyWarningTicks > 0 && !isRegenerating) {
            String key = EnergyHudLogic.getWarningTranslationKey(currentState);
            if (key != null) {
                textToDraw = class_2561.method_43471((String)key);
                textColor = -43691;
                --energyWarningTicks;
            } else {
                energyWarningTicks = 0;
            }
        } else {
            textToDraw = class_2561.method_43470((String)(energy + " / " + maxEnergy));
            textColor = -1;
        }
        if (textToDraw != null) {
            int w = client.field_1772.method_27525((class_5348)textToDraw);
            context.method_51439(client.field_1772, (class_2561)textToDraw, barCenterX - w / 2, iconsY + 10, textColor, true);
        }
    }

    public static void onCraftingFail() {
        craftingFailTicks = EnergyConfig.get().WarningMessageTime;
    }
}

